/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.pebble;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.MapModelAndView;
import io.jooby.ModelAndView;
import io.jooby.TemplateEngine;
import io.jooby.buffer.DataBuffer;
import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class PebbleTemplateEngine
implements TemplateEngine {
    private final List<String> extensions;
    private final PebbleEngine engine;

    PebbleTemplateEngine(PebbleEngine.Builder builder, List<String> extensions) {
        this.engine = builder.build();
        this.extensions = Collections.unmodifiableList(extensions);
    }

    @NonNull
    public List<String> extensions() {
        return this.extensions;
    }

    public boolean supports(@NonNull ModelAndView modelAndView) {
        return super.supports(modelAndView) && modelAndView instanceof MapModelAndView;
    }

    public DataBuffer render(Context ctx, ModelAndView modelAndView) throws Exception {
        if (modelAndView instanceof MapModelAndView) {
            MapModelAndView mapModelAndView = (MapModelAndView)modelAndView;
            DataBuffer buffer = ctx.getBufferFactory().allocateBuffer();
            PebbleTemplate template = this.engine.getTemplate(modelAndView.getView());
            HashMap model = new HashMap(ctx.getAttributes());
            model.putAll((Map)mapModelAndView.getModel());
            Locale locale = modelAndView.getLocale();
            if (locale == null) {
                locale = ctx.locale();
            }
            template.evaluate(buffer.asWriter(), model, locale);
            return buffer;
        }
        throw new IllegalArgumentException("Only " + MapModelAndView.class.getName() + " are supported");
    }
}

