/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.reactor;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.ReactiveSupport;
import io.jooby.Reified;
import io.jooby.ResultHandler;
import io.jooby.Route;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.concurrent.Flow;
import org.reactivestreams.FlowAdapters;
import org.slf4j.Logger;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Reactor
implements ResultHandler {
    private static final Route.Filter REACTOR = new Route.Filter(){

        private void after(Context ctx, Object value, Throwable failure) {
            Route.After after = ctx.getRoute().getAfter();
            if (after != null) {
                try {
                    after.apply(ctx, value, failure);
                }
                catch (Exception unexpected) {
                    Logger log = ctx.getRouter().getLog();
                    log.debug("After invocation resulted in exception", (Throwable)unexpected);
                }
            }
        }

        @NonNull
        public Route.Handler apply(@NonNull Route.Handler next) {
            return (Route.Handler & Serializable)ctx -> {
                Object result = next.apply(ctx);
                if (ctx.isResponseStarted()) {
                    return ctx;
                }
                if (result instanceof Flux) {
                    Flux flux = (Flux)result;
                    flux.subscribe(FlowAdapters.toSubscriber((Flow.Subscriber)ReactiveSupport.newSubscriber((Context)ctx)));
                    return ctx;
                }
                if (result instanceof Mono) {
                    Mono mono = (Mono)result;
                    mono.subscribe(value -> {
                        this.after(ctx, value, null);
                        ctx.render(value);
                    }, failure -> {
                        this.after(ctx, null, (Throwable)failure);
                        ctx.sendError((Throwable)failure);
                    });
                    return ctx;
                }
                return result;
            };
        }

        public void setRoute(Route route) {
            route.setNonBlocking(true);
        }
    };

    public static Route.Filter reactor() {
        return REACTOR;
    }

    public boolean matches(@NonNull Type type) {
        Class raw = Reified.get((Type)type).getRawType();
        return Mono.class.isAssignableFrom(raw) || Flux.class.isAssignableFrom(raw);
    }

    @NonNull
    public Route.Filter create() {
        return REACTOR;
    }

    public boolean isReactive() {
        return true;
    }
}

