/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.rocker;

import com.fizzed.rocker.ContentType;
import com.fizzed.rocker.RockerOutput;
import com.fizzed.rocker.RockerOutputFactory;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class ByteBufferOutput
implements RockerOutput<ByteBufferOutput> {
    public static final int BUFFER_SIZE = 4096;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private final ContentType contentType;
    protected byte[] buf;
    protected int count;

    ByteBufferOutput(ContentType contentType, int bufferSize) {
        this.buf = new byte[bufferSize];
        this.contentType = contentType;
    }

    void reset() {
        this.count = 0;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    public ByteBufferOutput w(String string) {
        return this.w(string.getBytes(StandardCharsets.UTF_8));
    }

    public ByteBufferOutput w(byte[] bytes) {
        int len = bytes.length;
        this.ensureCapacity(this.count + len);
        System.arraycopy(bytes, 0, this.buf, this.count, len);
        this.count += len;
        return this;
    }

    public int getByteLength() {
        return this.count;
    }

    public ByteBuffer toBuffer() {
        return ByteBuffer.wrap(this.buf, 0, this.count);
    }

    public byte[] toByteArray() {
        byte[] array = new byte[this.count];
        System.arraycopy(this.buf, 0, array, 0, this.count);
        return array;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buf.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = ByteBufferOutput.hugeCapacity(minCapacity);
        }
        this.buf = Arrays.copyOf(this.buf, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    static RockerOutputFactory<ByteBufferOutput> factory(int bufferSize) {
        return (contentType, charsetName) -> new ByteBufferOutput(contentType, bufferSize);
    }

    static RockerOutputFactory<ByteBufferOutput> reuse(final RockerOutputFactory<ByteBufferOutput> factory) {
        return new RockerOutputFactory<ByteBufferOutput>(){
            private final ThreadLocal<ByteBufferOutput> thread = new ThreadLocal();

            public ByteBufferOutput create(ContentType contentType, String charsetName) {
                ByteBufferOutput output = this.thread.get();
                if (output == null) {
                    output = (ByteBufferOutput)factory.create(contentType, charsetName);
                    this.thread.set(output);
                }
                output.reset();
                return output;
            }
        };
    }
}

