/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.rocker;

import com.fizzed.rocker.RockerOutputFactory;
import com.fizzed.rocker.runtime.RockerRuntime;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Environment;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.MessageEncoder;
import io.jooby.ResultHandler;
import io.jooby.ServiceRegistry;
import io.jooby.rocker.ByteBufferOutput;
import io.jooby.rocker.RockerMessageEncoder;
import io.jooby.rocker.RockerResultHandler;

public class RockerModule
implements Extension {
    private Boolean reloading;
    private int bufferSize = 4096;
    private boolean reuseBuffer;

    @NonNull
    public RockerModule reloading(boolean reloading) {
        this.reloading = reloading;
        return this;
    }

    @NonNull
    public RockerModule useBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public RockerModule reuseBuffer(boolean reuseBuffer) {
        this.reuseBuffer = reuseBuffer;
        return this;
    }

    public void install(@NonNull Jooby application) {
        Environment env = application.getEnvironment();
        RockerRuntime runtime = RockerRuntime.getInstance();
        boolean reloading = this.reloading == null ? env.isActive("dev", new String[0]) && runtime.isReloadingPossible() : this.reloading;
        RockerOutputFactory<ByteBufferOutput> factory = ByteBufferOutput.factory(this.bufferSize);
        if (this.reuseBuffer) {
            factory = ByteBufferOutput.reuse(factory);
        }
        runtime.setReloading(reloading);
        application.resultHandler((ResultHandler)new RockerResultHandler(factory));
        application.encoder((MessageEncoder)new RockerMessageEncoder(factory));
        ServiceRegistry services = application.getServices();
        services.put(RockerOutputFactory.class, factory);
    }
}

