/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.di;

import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.di.SpringRegistry;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.stereotype.Controller;

public class Spring
implements Extension {
    private AnnotationConfigApplicationContext applicationContext;
    private boolean registerMvcRoutes = true;
    private boolean refresh = true;
    private String[] packages;

    public Spring(@Nonnull AnnotationConfigApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Spring() {
        this.applicationContext = null;
    }

    public Spring(String ... packages) {
        this.applicationContext = null;
        this.packages = packages;
    }

    public Spring noRefresh() {
        this.refresh = false;
        return this;
    }

    public Spring noMvcRoutes() {
        this.registerMvcRoutes = false;
        return this;
    }

    public void install(@Nonnull Jooby application) throws Exception {
        if (this.applicationContext == null) {
            String[] packages = this.packages;
            if (packages == null) {
                String basePackage = application.getBasePackage();
                if (basePackage == null) {
                    throw new IllegalArgumentException("Spring application context requires at least one package to scan.");
                }
                packages = new String[]{basePackage};
            }
            this.applicationContext = Spring.defaultApplicationContext(packages);
            application.onStop((AutoCloseable)this.applicationContext);
        }
        if (this.refresh) {
            this.applicationContext.refresh();
        }
        application.registry((Object)new SpringRegistry((ApplicationContext)this.applicationContext));
        if (this.registerMvcRoutes) {
            String[] names = this.applicationContext.getBeanNamesForAnnotation(Controller.class);
            ClassLoader loader = application.getClass().getClassLoader();
            for (String name : names) {
                BeanDefinition bean = this.applicationContext.getBeanDefinition(name);
                Class<?> mvcClass = loader.loadClass(bean.getBeanClassName());
                application.mvc(mvcClass);
            }
        }
    }

    public static AnnotationConfigApplicationContext defaultApplicationContext(String ... packages) {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        context.scan(packages);
        return context;
    }
}

