/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.di;

import com.typesafe.config.Config;
import io.jooby.Environment;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.Registry;
import io.jooby.ServiceKey;
import io.jooby.ServiceRegistry;
import io.jooby.di.ConfigPropertySource;
import io.jooby.di.SpringRegistry;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Provider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Controller;

public class SpringModule
implements Extension {
    private AnnotationConfigApplicationContext applicationContext;
    private boolean registerMvcRoutes = true;
    private boolean refresh = true;
    private String[] packages;

    public SpringModule(@Nonnull AnnotationConfigApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public SpringModule() {
    }

    public SpringModule(String ... packages) {
        this.packages = packages;
    }

    public SpringModule noRefresh() {
        this.refresh = false;
        return this;
    }

    public SpringModule noMvcRoutes() {
        this.registerMvcRoutes = false;
        return this;
    }

    public boolean lateinit() {
        return true;
    }

    public void install(@Nonnull Jooby application) throws Exception {
        if (this.applicationContext == null) {
            String[] packages = this.packages;
            if (packages == null) {
                String basePackage = application.getBasePackage();
                if (basePackage == null) {
                    throw new IllegalArgumentException("SpringModule application context requires at least one package to scan.");
                }
                packages = new String[]{basePackage};
            }
            Environment environment = application.getEnvironment();
            this.applicationContext = new AnnotationConfigApplicationContext();
            this.applicationContext.scan(packages);
            ConfigurableEnvironment configurableEnvironment = this.applicationContext.getEnvironment();
            String[] profiles = environment.getActiveNames().toArray(new String[0]);
            configurableEnvironment.setActiveProfiles(profiles);
            configurableEnvironment.setDefaultProfiles(profiles);
            Config config = environment.getConfig();
            MutablePropertySources propertySources = configurableEnvironment.getPropertySources();
            propertySources.addFirst((PropertySource)new ConfigPropertySource(config));
            ConfigurableListableBeanFactory beanFactory = this.applicationContext.getBeanFactory();
            beanFactory.registerSingleton("conf", (Object)config);
            beanFactory.registerSingleton("env", (Object)environment);
            beanFactory.registerSingleton("environment", (Object)configurableEnvironment);
            ServiceRegistry registry = application.getServices();
            for (Map.Entry entry : registry.entrySet()) {
                ServiceKey key = (ServiceKey)entry.getKey();
                Provider provider = (Provider)entry.getValue();
                this.applicationContext.registerBean(key.getName(), key.getType(), () -> provider.get(), new BeanDefinitionCustomizer[0]);
            }
            application.onStop((AutoCloseable)this.applicationContext);
        }
        if (this.refresh) {
            this.applicationContext.refresh();
        }
        application.registry((Registry)new SpringRegistry((ApplicationContext)this.applicationContext));
        if (this.registerMvcRoutes) {
            String[] names = this.applicationContext.getBeanNamesForAnnotation(Controller.class);
            ClassLoader loader = application.getClass().getClassLoader();
            for (String name : names) {
                BeanDefinition bean = this.applicationContext.getBeanDefinition(name);
                Class<?> mvcClass = loader.loadClass(bean.getBeanClassName());
                application.mvc(mvcClass);
            }
        }
    }
}

