/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.di;

import io.jooby.Registry;
import io.jooby.ServiceKey;
import io.jooby.exception.RegistryException;
import javax.annotation.Nonnull;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

class SpringRegistry
implements Registry {
    private final ApplicationContext ctx;

    SpringRegistry(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    @Nonnull
    public <T> T require(@Nonnull Class<T> type) {
        try {
            return (T)this.ctx.getBean(type);
        }
        catch (BeansException cause) {
            throw new RegistryException("Provisioning of `" + type.getName() + "` resulted in exception", (Throwable)cause);
        }
    }

    @Nonnull
    public <T> T require(@Nonnull Class<T> type, @Nonnull String name) {
        try {
            return (T)this.ctx.getBean(name, type);
        }
        catch (BeansException cause) {
            throw new RegistryException("Provisioning of `" + type.getName() + "(" + name + ")` resulted in exception", (Throwable)cause);
        }
    }

    @Nonnull
    public <T> T require(@Nonnull ServiceKey<T> key) throws RegistryException {
        String name = key.getName();
        return name == null ? this.require(key.getType()) : this.require(key.getType(), name);
    }
}

