/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.thymeleaf;

import io.jooby.Context;
import io.jooby.ModelAndView;
import io.jooby.TemplateEngine;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.thymeleaf.context.IContext;

public class ThymeleafTemplateEngine
implements TemplateEngine {
    private org.thymeleaf.TemplateEngine templateEngine;
    private List<String> extensions;

    public ThymeleafTemplateEngine(org.thymeleaf.TemplateEngine templateEngine, List<String> extensions) {
        this.templateEngine = templateEngine;
        this.extensions = Collections.unmodifiableList(extensions);
    }

    @Nonnull
    public List<String> extensions() {
        return this.extensions;
    }

    public String render(Context ctx, ModelAndView modelAndView) {
        HashMap model = new HashMap(ctx.getAttributes());
        model.putAll(modelAndView.getModel());
        Locale locale = modelAndView.getLocale();
        if (locale == null) {
            locale = ctx.locale();
        }
        org.thymeleaf.context.Context context = new org.thymeleaf.context.Context(locale, model);
        String templateName = modelAndView.getView();
        if (!templateName.startsWith("/")) {
            templateName = "/" + templateName;
        }
        return this.templateEngine.process(templateName, (IContext)context);
    }
}

