/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.utow;

import io.jooby.Body;
import io.jooby.ByteRange;
import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.DefaultContext;
import io.jooby.FileUpload;
import io.jooby.Formdata;
import io.jooby.MediaType;
import io.jooby.Multipart;
import io.jooby.QueryString;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.RouterOption;
import io.jooby.Sender;
import io.jooby.Server;
import io.jooby.ServerSentEmitter;
import io.jooby.Session;
import io.jooby.SessionStore;
import io.jooby.SneakyThrows;
import io.jooby.StatusCode;
import io.jooby.Value;
import io.jooby.ValueNode;
import io.jooby.WebSocket;
import io.jooby.WebSocketConfigurer;
import io.jooby.internal.utow.UtowChunkedStream;
import io.jooby.internal.utow.UtowCompletionListener;
import io.jooby.internal.utow.UtowFileUpload;
import io.jooby.internal.utow.UtowSender;
import io.jooby.internal.utow.UtowSeverSentEmitter;
import io.jooby.internal.utow.UtowWebSocket;
import io.jooby.internal.utow.UtowWriter;
import io.undertow.Handlers;
import io.undertow.io.IoCallback;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.SameThreadExecutor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class UtowContext
implements DefaultContext,
IoCallback {
    private static final ByteBuffer EMPTY = ByteBuffer.wrap(new byte[0]);
    private Route route;
    HttpServerExchange exchange;
    private Router router;
    private QueryString query;
    private Formdata form;
    private Multipart multipart;
    private ValueNode headers;
    private Map<String, String> pathMap = Collections.EMPTY_MAP;
    private Map<String, Object> attributes;
    Body body;
    private MediaType responseType;
    private Map<String, String> cookies;
    private HashMap<String, String> responseCookies;
    private long responseLength = -1L;
    private Boolean resetHeadersOnError;
    private final String method;
    private final String requestPath;
    private UtowCompletionListener completionListener;

    public UtowContext(HttpServerExchange exchange, Router router) {
        this.exchange = exchange;
        this.router = router;
        this.method = exchange.getRequestMethod().toString().toUpperCase();
        this.requestPath = exchange.getRequestPath();
    }

    @Nonnull
    public Router getRouter() {
        return this.router;
    }

    @Nonnull
    public Body body() {
        return this.body == null ? Body.empty((Context)this) : this.body;
    }

    @Nonnull
    public Map<String, String> cookieMap() {
        if (this.cookies == null) {
            Collection cookies = this.exchange.getRequestCookies().values();
            if (cookies.size() > 0) {
                this.cookies = new LinkedHashMap<String, String>(cookies.size());
                for (io.undertow.server.handlers.Cookie it : cookies) {
                    this.cookies.put(it.getName(), it.getValue());
                }
            } else {
                this.cookies = Collections.emptyMap();
            }
        }
        return this.cookies;
    }

    @Nonnull
    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        return this.attributes;
    }

    @Nonnull
    public String getMethod() {
        return this.method;
    }

    @Nonnull
    public Route getRoute() {
        return this.route;
    }

    @Nonnull
    public Context setRoute(Route route) {
        this.route = route;
        return this;
    }

    @Nonnull
    public String pathString() {
        return this.getRequestPath();
    }

    @Nonnull
    public String getRequestPath() {
        return this.requestPath;
    }

    @Nonnull
    public Map<String, String> pathMap() {
        return this.pathMap;
    }

    @Nonnull
    public Context setPathMap(Map<String, String> pathMap) {
        this.pathMap = pathMap;
        return this;
    }

    public boolean isInIoThread() {
        return this.exchange.isInIoThread();
    }

    @Nonnull
    public String getRemoteAddress() {
        return this.exchange.getSourceAddress().getHostString();
    }

    @Nonnull
    public String getProtocol() {
        return this.exchange.getProtocol().toString();
    }

    @Nonnull
    public String getScheme() {
        String scheme = this.exchange.getRequestScheme();
        return scheme == null ? "http" : scheme.toLowerCase();
    }

    @Nonnull
    public Value header(@Nonnull String name) {
        return Value.create((Context)this, (String)name, (List)this.exchange.getRequestHeaders().get(name));
    }

    @Nonnull
    public ValueNode header() {
        HeaderMap map = this.exchange.getRequestHeaders();
        if (this.headers == null) {
            LinkedHashMap<String, HeaderValues> headerMap = new LinkedHashMap<String, HeaderValues>();
            Collection names = map.getHeaderNames();
            for (HttpString name : names) {
                HeaderValues values = map.get(name);
                headerMap.put(name.toString(), values);
            }
            this.headers = Value.hash((Context)this, headerMap);
        }
        return this.headers;
    }

    @Nonnull
    public QueryString query() {
        if (this.query == null) {
            this.query = QueryString.create((Context)this, (String)this.exchange.getQueryString());
        }
        return this.query;
    }

    @Nonnull
    public Formdata form() {
        if (this.form == null) {
            this.form = Formdata.create((Context)this);
            this.formData(this.form, (FormData)this.exchange.getAttachment(FormDataParser.FORM_DATA));
        }
        return this.form;
    }

    @Nonnull
    public Multipart multipart() {
        if (this.multipart == null) {
            this.multipart = Multipart.create((Context)this);
            this.form = this.multipart;
            this.formData((Formdata)this.multipart, (FormData)this.exchange.getAttachment(FormDataParser.FORM_DATA));
        }
        return this.multipart;
    }

    @Nonnull
    public Context dispatch(@Nonnull Runnable action) {
        return this.dispatch(this.router.getWorker(), action);
    }

    @Nonnull
    public Context dispatch(@Nonnull Executor executor, @Nonnull Runnable action) {
        this.exchange.dispatch(executor, action);
        return this;
    }

    @Nonnull
    public Context detach(@Nonnull Route.Handler next) {
        this.exchange.dispatch(SameThreadExecutor.INSTANCE, () -> {
            try {
                next.apply((Context)this);
            }
            catch (Throwable x) {
                this.sendError(x);
            }
        });
        return this;
    }

    @Nonnull
    public Context upgrade(@Nonnull WebSocket.Initializer handler) {
        try {
            Handlers.websocket((exchange, channel) -> {
                UtowWebSocket ws = new UtowWebSocket(this, channel);
                handler.init(Context.readOnly((Context)this), (WebSocketConfigurer)ws);
                ws.fireConnect();
            }).handleRequest(this.exchange);
            return this;
        }
        catch (Exception x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    @Nonnull
    public Context upgrade(@Nonnull ServerSentEmitter.Handler handler) {
        try {
            handler.handle((ServerSentEmitter)new UtowSeverSentEmitter(this));
        }
        catch (Throwable x) {
            this.sendError(x);
        }
        return this;
    }

    @Nonnull
    public StatusCode getResponseCode() {
        return StatusCode.valueOf((int)this.exchange.getStatusCode());
    }

    @Nonnull
    public Context setResponseCode(int statusCode) {
        this.exchange.setStatusCode(statusCode);
        return this;
    }

    @Nonnull
    public Context setResponseHeader(@Nonnull String name, @Nonnull String value) {
        this.exchange.getResponseHeaders().put(HttpString.tryFromString((String)name), value);
        return this;
    }

    @Nonnull
    public Context removeResponseHeader(@Nonnull String name) {
        this.exchange.getResponseHeaders().remove(name);
        return this;
    }

    @Nonnull
    public Context removeResponseHeaders() {
        this.exchange.getResponseHeaders().clear();
        return this;
    }

    @Nonnull
    public MediaType getResponseType() {
        return this.responseType == null ? MediaType.text : this.responseType;
    }

    @Nonnull
    public Context setDefaultResponseType(@Nonnull MediaType contentType) {
        if (this.responseType == null) {
            this.setResponseType(contentType, contentType.getCharset());
        }
        return this;
    }

    @Nonnull
    public Context setResponseType(@Nonnull MediaType contentType, @Nullable Charset charset) {
        this.responseType = contentType;
        this.exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, contentType.toContentTypeHeader(charset));
        return this;
    }

    @Nonnull
    public Context setResponseType(@Nonnull String contentType) {
        this.responseType = MediaType.valueOf((String)contentType);
        this.exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, contentType);
        return this;
    }

    @Nullable
    public String getResponseHeader(@Nonnull String name) {
        return this.exchange.getResponseHeaders().getFirst(name);
    }

    @Nonnull
    public Context setResponseLength(long length) {
        this.responseLength = length;
        this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, Long.toString(length));
        return this;
    }

    public long getResponseLength() {
        if (this.responseLength == -1L) {
            return this.exchange.getResponseContentLength();
        }
        return this.responseLength;
    }

    @Nonnull
    public Context setResponseCookie(@Nonnull Cookie cookie) {
        if (this.responseCookies == null) {
            this.responseCookies = new HashMap();
        }
        cookie.setPath(cookie.getPath(this.getContextPath()));
        this.responseCookies.put(cookie.getName(), cookie.toCookieString());
        HeaderMap headers = this.exchange.getResponseHeaders();
        headers.remove(Headers.SET_COOKIE);
        for (String cookieString : this.responseCookies.values()) {
            headers.add(Headers.SET_COOKIE, cookieString);
        }
        return this;
    }

    @Nonnull
    public OutputStream responseStream() {
        this.ifStartBlocking();
        this.ifSetChunked();
        return this.exchange.getOutputStream();
    }

    @Nonnull
    public Sender responseSender() {
        return new UtowSender(this, this.exchange);
    }

    @Nonnull
    public PrintWriter responseWriter(MediaType type, Charset charset) {
        this.ifStartBlocking();
        this.setResponseType(type, charset);
        this.ifSetChunked();
        return new PrintWriter(new UtowWriter(this.exchange.getOutputStream(), charset));
    }

    @Nonnull
    public Context send(@Nonnull byte[] data) {
        return this.send(ByteBuffer.wrap(data));
    }

    @Nonnull
    public Context send(@Nonnull ReadableByteChannel channel) {
        this.ifSetChunked();
        new UtowChunkedStream(this.exchange.getRequestContentLength()).send(channel, this.exchange, this);
        return this;
    }

    @Nonnull
    public Context send(@Nonnull String data, @Nonnull Charset charset) {
        return this.send(ByteBuffer.wrap(data.getBytes(charset)));
    }

    @Nonnull
    public Context send(@Nonnull ByteBuffer[] data) {
        HeaderMap headers = this.exchange.getResponseHeaders();
        if (!headers.contains(Headers.CONTENT_LENGTH)) {
            long len = 0L;
            for (ByteBuffer b : data) {
                len += (long)b.remaining();
            }
            this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, Long.toString(len));
        }
        this.exchange.getResponseSender().send(data, (IoCallback)this);
        return this;
    }

    @Nonnull
    public Context send(@Nonnull ByteBuffer data) {
        this.exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, Long.toString(data.remaining()));
        this.exchange.getResponseSender().send(data, (IoCallback)this);
        return this;
    }

    @Nonnull
    public Context send(StatusCode statusCode) {
        this.exchange.setStatusCode(statusCode.value());
        this.exchange.getResponseSender().send(EMPTY, (IoCallback)this);
        return this;
    }

    @Nonnull
    public Context send(@Nonnull InputStream in) {
        if (in instanceof FileInputStream) {
            return this.send(((FileInputStream)in).getChannel());
        }
        try {
            this.ifSetChunked();
            long len = this.exchange.getResponseContentLength();
            ByteRange range = ByteRange.parse((String)this.exchange.getRequestHeaders().getFirst(Headers.RANGE), (long)len).apply((Context)this);
            new UtowChunkedStream(len).send(Channels.newChannel(range.apply(in)), this.exchange, this);
            return this;
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    @Nonnull
    public Context send(@Nonnull FileChannel file) {
        try {
            long len = file.size();
            this.exchange.setResponseContentLength(len);
            ByteRange range = ByteRange.parse((String)this.exchange.getRequestHeaders().getFirst(Headers.RANGE), (long)len).apply((Context)this);
            file.position(range.getStart());
            new UtowChunkedStream(range.getEnd()).send(file, this.exchange, this);
            return this;
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    public boolean isResponseStarted() {
        return this.exchange.isResponseStarted();
    }

    public boolean getResetHeadersOnError() {
        return this.resetHeadersOnError == null ? this.getRouter().getRouterOptions().contains(RouterOption.RESET_HEADERS_ON_ERROR) : this.resetHeadersOnError.booleanValue();
    }

    public Context setResetHeadersOnError(boolean value) {
        this.resetHeadersOnError = value;
        return this;
    }

    public void onComplete(HttpServerExchange exchange, io.undertow.io.Sender sender) {
        this.ifSaveSession();
        this.destroy(null);
    }

    @Nonnull
    public Context onComplete(@Nonnull Route.Complete task) {
        if (this.completionListener == null) {
            this.completionListener = new UtowCompletionListener(this);
            this.exchange.addExchangeCompleteListener((ExchangeCompletionListener)this.completionListener);
        }
        this.completionListener.addListener(task);
        return this;
    }

    public void onException(HttpServerExchange exchange, io.undertow.io.Sender sender, IOException exception) {
        this.destroy(exception);
    }

    public String toString() {
        return this.getMethod() + " " + this.pathString();
    }

    private void ifSaveSession() {
        Session session;
        if (this.attributes != null && (session = (Session)this.attributes.get("session")) != null && (session.isNew() || session.isModify())) {
            SessionStore store = this.router.getSessionStore();
            store.saveSession((Context)this, session);
        }
    }

    void destroy(Exception cause) {
        try {
            if (cause != null) {
                Logger log = this.router.getLog();
                if (Server.connectionLost((Throwable)cause)) {
                    log.debug("exception found while sending response {} {}", new Object[]{this.getMethod(), this.pathString(), cause});
                } else {
                    log.error("exception found while sending response {} {}", new Object[]{this.getMethod(), this.pathString(), cause});
                }
            }
        }
        finally {
            this.exchange.endExchange();
        }
    }

    private void formData(Formdata form, FormData data) {
        if (data != null) {
            for (String path : data) {
                Deque values = data.get(path);
                for (FormData.FormValue value : values) {
                    if (value.isFileItem()) {
                        ((Multipart)form).put(path, (FileUpload)new UtowFileUpload(value));
                        continue;
                    }
                    form.put(path, value.getValue());
                }
            }
        }
    }

    private void ifSetChunked() {
        HeaderMap responseHeaders = this.exchange.getResponseHeaders();
        if (!responseHeaders.contains(Headers.CONTENT_LENGTH)) {
            this.exchange.getResponseHeaders().put(Headers.TRANSFER_ENCODING, Headers.CHUNKED.toString());
        }
    }

    private void ifStartBlocking() {
        if (!this.exchange.isBlocking()) {
            this.exchange.startBlocking();
        }
    }
}

