/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.utow;

import io.jooby.Context;
import io.jooby.Router;
import io.jooby.StatusCode;
import io.jooby.exception.StatusCodeException;
import io.jooby.internal.utow.UtowBodyHandler;
import io.jooby.internal.utow.UtowContext;
import io.undertow.io.Receiver;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormEncodedDataDefinition;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.handlers.form.MultiPartParserDefinition;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.nio.charset.StandardCharsets;

public class UtowHandler
implements HttpHandler {
    protected final Router router;
    private final long maxRequestSize;
    private final int bufferSize;
    private final boolean defaultHeaders;

    public UtowHandler(Router router, int bufferSize, long maxRequestSize, boolean defaultHeaders) {
        this.router = router;
        this.maxRequestSize = maxRequestSize;
        this.bufferSize = bufferSize;
        this.defaultHeaders = defaultHeaders;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        UtowContext context = new UtowContext(exchange, this.router);
        Router.Match route = this.router.match((Context)context);
        HeaderMap responseHeaders = exchange.getResponseHeaders();
        responseHeaders.put(Headers.CONTENT_TYPE, "text/plain");
        if (this.defaultHeaders) {
            responseHeaders.put(Headers.SERVER, "U");
        }
        HeaderMap headers = exchange.getRequestHeaders();
        long len = UtowHandler.parseLen(headers.getFirst(Headers.CONTENT_LENGTH));
        String chunked = headers.getFirst(Headers.TRANSFER_ENCODING);
        if (len > 0L || chunked != null) {
            if (len > this.maxRequestSize) {
                context.sendError((Throwable)new StatusCodeException(StatusCode.REQUEST_ENTITY_TOO_LARGE));
                return;
            }
            if (!route.matches()) {
                route.execute((Context)context);
                return;
            }
            FormDataParser parser = FormParserFactory.builder((boolean)false).addParser((FormParserFactory.ParserDefinition)new MultiPartParserDefinition(this.router.getTmpdir()).setDefaultEncoding(StandardCharsets.UTF_8.name())).addParser((FormParserFactory.ParserDefinition)new FormEncodedDataDefinition().setDefaultEncoding(StandardCharsets.UTF_8.name())).build().createParser(exchange);
            if (parser == null) {
                Receiver receiver = exchange.getRequestReceiver();
                UtowBodyHandler reader = new UtowBodyHandler(route, context, this.bufferSize, this.maxRequestSize);
                if (len > 0L && len <= (long)this.bufferSize) {
                    receiver.receiveFullBytes((Receiver.FullBytesCallback)reader);
                } else {
                    receiver.receivePartialBytes((Receiver.PartialBytesCallback)reader);
                }
            } else {
                try {
                    parser.parse(UtowHandler.execute(route, (Context)context));
                }
                catch (Exception x) {
                    context.sendError(x, StatusCode.BAD_REQUEST);
                }
            }
        } else {
            route.execute((Context)context);
        }
    }

    private static long parseLen(String value) {
        try {
            return value == null ? -1L : Long.parseLong(value);
        }
        catch (NumberFormatException x) {
            return -1L;
        }
    }

    private static HttpHandler execute(Router.Match route, Context ctx) {
        return exchange -> route.execute(ctx);
    }
}

