/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.utow;

import io.jooby.Context;
import io.jooby.Sender;
import io.jooby.internal.utow.UtowContext;
import io.undertow.io.IoCallback;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public class UtowSender
implements Sender {
    private final UtowContext ctx;
    private final HttpServerExchange exchange;

    public UtowSender(UtowContext ctx, HttpServerExchange exchange) {
        this.ctx = ctx;
        this.exchange = exchange;
    }

    public Sender write(@Nonnull byte[] data, @Nonnull Sender.Callback callback) {
        this.exchange.getResponseSender().send(ByteBuffer.wrap(data), UtowSender.newIoCallback(this.ctx, callback));
        return this;
    }

    public void close() {
        this.ctx.destroy(null);
    }

    private static IoCallback newIoCallback(final UtowContext ctx, final Sender.Callback callback) {
        return new IoCallback(){

            public void onComplete(HttpServerExchange exchange, io.undertow.io.Sender sender) {
                callback.onComplete((Context)ctx, null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onException(HttpServerExchange exchange, io.undertow.io.Sender sender, IOException exception) {
                try {
                    callback.onComplete((Context)ctx, (Throwable)exception);
                }
                finally {
                    ctx.destroy(exception);
                }
            }
        };
    }
}

