/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.utow;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;

public class UtowWriter
extends Writer {
    private Charset charset;
    private OutputStream out;

    public UtowWriter(OutputStream out, Charset charset) {
        this.out = out;
        this.charset = charset;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        byte[] bytes = new String(cbuf, off, len).getBytes(this.charset);
        this.out.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(String str) throws IOException {
        byte[] bytes = str.getBytes(this.charset);
        this.out.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.write(str.substring(off, len));
    }

    @Override
    public void write(int c) throws IOException {
        this.out.write((char)c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public Writer append(char c) throws IOException {
        this.out.write(c);
        return this;
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        if (csq == null) {
            throw new NullPointerException("CharSequence");
        }
        this.write(csq.toString());
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        if (csq == null) {
            throw new NullPointerException("CharSequence");
        }
        this.append(csq.subSequence(start, end));
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

