/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.utow;

import io.jooby.Jooby;
import io.jooby.Router;
import io.jooby.Server;
import io.jooby.ServerOptions;
import io.jooby.SneakyThrows;
import io.jooby.internal.utow.UtowHandler;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.server.handlers.encoding.EncodingHandler;
import java.net.BindException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLContext;
import org.xnio.Options;

public class Utow
extends Server.Base {
    private static final int BACKLOG = 8192;
    private Undertow server;
    private GracefulShutdownHandler shutdown;
    private List<Jooby> applications = new ArrayList<Jooby>();
    private ServerOptions options = new ServerOptions().setIoThreads(ServerOptions.IO_THREADS).setServer("utow");

    @Nonnull
    public Utow setOptions(@Nonnull ServerOptions options) {
        this.options = options.setIoThreads(options.getIoThreads());
        return this;
    }

    @Nonnull
    public ServerOptions getOptions() {
        return this.options;
    }

    public Server start(@Nonnull Jooby application) {
        try {
            this.applications.add(application);
            this.addShutdownHook();
            UtowHandler handler = new UtowHandler((Router)this.applications.get(0), this.options.getBufferSize(), this.options.getMaxRequestSize(), this.options.getDefaultHeaders());
            if (this.options.getGzip()) {
                handler = new EncodingHandler.Builder().build(null).wrap((HttpHandler)handler);
            }
            this.shutdown = new GracefulShutdownHandler((HttpHandler)handler);
            Undertow.Builder builder = Undertow.builder().addHttpListener(this.options.getPort(), this.options.getHost()).setBufferSize(this.options.getBufferSize()).setSocketOption(Options.BACKLOG, (Object)8192).setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, (Object)false).setServerOption(UndertowOptions.ALLOW_EQUALS_IN_COOKIE_VALUE, (Object)true).setServerOption(UndertowOptions.ALWAYS_SET_DATE, (Object)this.options.getDefaultHeaders()).setServerOption(UndertowOptions.RECORD_REQUEST_START_TIME, (Object)false).setServerOption(UndertowOptions.DECODE_URL, (Object)false).setIoThreads(this.options.getIoThreads()).setWorkerOption(Options.WORKER_NAME, (Object)"worker").setWorkerThreads(this.options.getWorkerThreads()).setHandler((HttpHandler)this.shutdown);
            SSLContext sslContext = this.options.getSSLContext(application.getEnvironment().getClassLoader());
            if (sslContext != null) {
                builder.addHttpsListener(this.options.getSecurePort().intValue(), this.options.getHost(), sslContext);
            }
            this.server = builder.build();
            this.server.start();
            this.fireStart(this.applications, (Executor)this.server.getWorker());
            this.fireReady(Collections.singletonList(application));
            return this;
        }
        catch (RuntimeException x) {
            Throwable cause = Optional.ofNullable(x.getCause()).orElse(x);
            if (cause instanceof BindException) {
                cause = new BindException("Address already in use: " + this.options.getPort());
            }
            throw SneakyThrows.propagate((Throwable)cause);
        }
    }

    @Nonnull
    public synchronized Server stop() {
        this.fireStop(this.applications);
        this.applications = null;
        try {
            this.shutdown.shutdown();
            this.shutdown.awaitShutdown(TimeUnit.SECONDS.toMillis(1L));
        }
        catch (Exception x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
        finally {
            this.shutdownServer();
        }
        return this;
    }

    private void shutdownServer() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            finally {
                this.server = null;
            }
        }
    }
}

