/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.persistence.local.journal;

import io.journalkeeper.persistence.JournalPersistence;
import io.journalkeeper.persistence.MonitoredPersistence;
import io.journalkeeper.persistence.TooManyBytesException;
import io.journalkeeper.persistence.local.cache.MemoryCacheManager;
import io.journalkeeper.persistence.local.journal.CorruptedStoreException;
import io.journalkeeper.persistence.local.journal.DiskFullException;
import io.journalkeeper.persistence.local.journal.LocalStoreFile;
import io.journalkeeper.persistence.local.journal.PositionOverflowException;
import io.journalkeeper.persistence.local.journal.PositionUnderflowException;
import io.journalkeeper.persistence.local.journal.StoreFile;
import io.journalkeeper.utils.ThreadSafeFormat;
import io.journalkeeper.utils.spi.ServiceSupport;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositioningStore
implements JournalPersistence,
MonitoredPersistence,
Closeable {
    private final Logger logger = LoggerFactory.getLogger(PositioningStore.class);
    private final MemoryCacheManager bufferPool;
    private final NavigableMap<Long, StoreFile> storeFileMap = new ConcurrentSkipListMap<Long, StoreFile>();
    private final Object fileMapMutex = new Object();
    private File base;
    private AtomicLong flushPosition = new AtomicLong(0L);
    private AtomicLong writePosition = new AtomicLong(0L);
    private AtomicLong leftPosition = new AtomicLong(0L);
    private StoreFile writeStoreFile = null;
    private Config config = null;

    public PositioningStore() {
        this.bufferPool = (MemoryCacheManager)ServiceSupport.load(MemoryCacheManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long givenMax) throws IOException {
        Object object = this.fileMapMutex;
        synchronized (object) {
            if (givenMax == this.max()) {
                return;
            }
            this.logger.info("Truncate to position: {}, min: {}, max: {}, flushed: {}, path: {}...", new Object[]{ThreadSafeFormat.formatWithComma((long)givenMax), ThreadSafeFormat.formatWithComma((long)this.min()), ThreadSafeFormat.formatWithComma((long)this.max()), ThreadSafeFormat.formatWithComma((long)this.flushPosition.get()), this.base.getAbsolutePath()});
            if (givenMax < this.min() || givenMax > this.max()) {
                throw new IllegalArgumentException(String.format("GivenMax %s should between [%s, %s]!", ThreadSafeFormat.formatWithComma((long)givenMax), ThreadSafeFormat.formatWithComma((long)this.min()), ThreadSafeFormat.formatWithComma((long)this.max())));
            }
            if (givenMax < this.max()) {
                this.rollbackFiles(givenMax);
                this.writePosition.set(givenMax);
                if (this.flushPosition.get() > givenMax) {
                    this.flushPosition.set(givenMax);
                }
                this.resetWriteStoreFile();
            }
        }
    }

    private void clearData() throws IOException {
        for (StoreFile storeFile : this.storeFileMap.values()) {
            File file;
            if (storeFile.hasPage()) {
                storeFile.unload();
            }
            if (!(file = storeFile.file()).exists() || file.delete()) continue;
            throw new IOException(String.format("Can not delete file: %s.", file.getAbsolutePath()));
        }
        this.storeFileMap.clear();
        this.writeStoreFile = null;
    }

    public void delete() throws IOException {
        this.clearData();
        if (this.base.exists() && !this.base.delete()) {
            throw new IOException(String.format("Can not delete Directory: %s.", this.base.getAbsolutePath()));
        }
    }

    private void rollbackFiles(long position) throws IOException {
        if (!this.storeFileMap.isEmpty()) {
            Map.Entry<Long, StoreFile> entry = this.storeFileMap.floorEntry(position);
            StoreFile storeFile = entry.getValue();
            if (position > storeFile.position()) {
                int relPos = (int)(position - storeFile.position());
                this.logger.info("Truncate store file {} to relative position {}.", (Object)storeFile.file().getAbsolutePath(), (Object)relPos);
                storeFile.rollback(relPos);
            }
            SortedMap<Long, StoreFile> toBeRemoved = this.storeFileMap.tailMap(position);
            for (StoreFile sf : toBeRemoved.values()) {
                this.logger.info("Delete store file {}.", (Object)sf.file().getAbsolutePath());
                this.forceDeleteStoreFile(sf);
                if (this.writeStoreFile != sf) continue;
                this.writeStoreFile = null;
            }
            toBeRemoved.clear();
        }
    }

    private void resetWriteStoreFile() {
        StoreFile storeFile;
        if (!this.storeFileMap.isEmpty() && (storeFile = this.storeFileMap.lastEntry().getValue()).position() + (long)storeFile.size() > this.writePosition.get()) {
            this.writeStoreFile = storeFile;
        }
    }

    public void recover(Path path, long min, Properties properties) throws IOException {
        Files.createDirectories(path, new FileAttribute[0]);
        this.base = path.toFile();
        this.config = this.toConfig(properties);
        this.bufferPool.addPreLoad(this.config.getFileDataSize(), this.config.getCachedFileCoreCount(), this.config.getCachedFileMaxCount());
        this.recoverFileMap(min);
        long recoverPosition = this.storeFileMap.isEmpty() ? min : (Long)this.storeFileMap.lastKey() + (long)this.storeFileMap.lastEntry().getValue().fileDataSize();
        this.flushPosition.set(recoverPosition);
        this.writePosition.set(recoverPosition);
        this.leftPosition.set(this.storeFileMap.isEmpty() ? min : (Long)this.storeFileMap.firstKey());
        this.resetWriteStoreFile();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Store loaded, left: {}, right: {},  base: {}.", new Object[]{ThreadSafeFormat.formatWithComma((long)this.min()), ThreadSafeFormat.formatWithComma((long)this.max()), this.base.getAbsolutePath()});
        }
    }

    private Config toConfig(Properties properties) {
        Config config = new Config();
        config.setFileDataSize(Integer.parseInt(properties.getProperty("file_data_size", String.valueOf(0x8000000))));
        config.setFileHeaderSize(Integer.parseInt(properties.getProperty("file_header_size", String.valueOf(128))));
        config.setCachedFileCoreCount(Integer.parseInt(properties.getProperty("cached_file_core_count", String.valueOf(0))));
        config.setCachedFileMaxCount(Integer.parseInt(properties.getProperty("cached_file_max_count", String.valueOf(2))));
        config.setMaxDirtySize(Long.parseLong(properties.getProperty("max_dirty_size", String.valueOf(0L))));
        return config;
    }

    private void recoverFileMap(long min) {
        File[] files = this.base.listFiles(file -> file.isFile() && file.getName().matches("\\d+"));
        if (null != files) {
            for (File file2 : files) {
                long filePosition = Long.parseLong(file2.getName());
                if (filePosition >= min || filePosition + file2.length() - (long)this.config.getFileHeaderSize() > min) {
                    this.storeFileMap.put(filePosition, new LocalStoreFile(filePosition, this.base, this.config.getFileHeaderSize(), this.bufferPool, this.config.getFileDataSize()));
                    continue;
                }
                this.logger.info("Ignore file {}, cause file position is smaller than given min position {}.", (Object)file2.getAbsolutePath(), (Object)min);
            }
        }
        if (!this.storeFileMap.isEmpty()) {
            long position = (Long)this.storeFileMap.firstKey();
            for (Map.Entry fileEntry : this.storeFileMap.entrySet()) {
                if (position != (Long)fileEntry.getKey()) {
                    throw new CorruptedStoreException(String.format("Files are not continuous! expect: %d, actual file name: %d, store: %s.", position, fileEntry.getKey(), this.base.getAbsolutePath()));
                }
                position += ((StoreFile)fileEntry.getValue()).file().length() - (long)this.config.getFileHeaderSize();
            }
        }
    }

    public long append(byte[] bytes) throws IOException {
        if (bytes.length > this.config.fileDataSize) {
            throw new TooManyBytesException(bytes.length, this.config.fileDataSize, this.base.toPath());
        }
        this.maybeWaitForFlush();
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        if (null == this.writeStoreFile) {
            this.writeStoreFile = this.createStoreFile(this.writePosition.get());
        }
        if (this.writeStoreFile.size() - this.writeStoreFile.writePosition() < buffer.remaining()) {
            this.writeStoreFile.closeWrite();
            this.writeStoreFile = this.createStoreFile(this.writePosition.get());
        }
        return this.writePosition.addAndGet(this.writeStoreFile.append(buffer));
    }

    public long append(List<byte[]> bytesList) throws IOException {
        int totalLength = 0;
        ArrayList<ByteBuffer> byteBufferList = new ArrayList<ByteBuffer>(bytesList.size());
        for (byte[] bytes : bytesList) {
            totalLength += bytes.length;
            byteBufferList.add(ByteBuffer.wrap(bytes));
        }
        if (totalLength > this.config.fileDataSize) {
            throw new TooManyBytesException(totalLength, this.config.fileDataSize, this.base.toPath());
        }
        this.maybeWaitForFlush();
        if (null == this.writeStoreFile) {
            this.writeStoreFile = this.createStoreFile(this.writePosition.get());
        }
        if (this.writeStoreFile.size() - this.writeStoreFile.writePosition() < totalLength) {
            this.writeStoreFile.closeWrite();
            this.writeStoreFile = this.createStoreFile(this.writePosition.get());
        }
        return this.writePosition.addAndGet(this.writeStoreFile.append(byteBufferList));
    }

    private void maybeWaitForFlush() {
        while (this.config.getMaxDirtySize() > 0L && this.max() - this.flushed() > this.config.getMaxDirtySize()) {
            Thread.yield();
        }
    }

    public long min() {
        return this.leftPosition.get();
    }

    public long physicalMin() {
        return this.storeFileMap.isEmpty() ? this.min() : ((Long)this.storeFileMap.firstKey()).longValue();
    }

    public long max() {
        return this.writePosition.get();
    }

    public long flushed() {
        return this.flushPosition.get();
    }

    public void flush() throws IOException {
        if (this.flushPosition.get() < this.writePosition.get()) {
            Map.Entry<Long, StoreFile> entry = this.storeFileMap.floorEntry(this.flushPosition.get());
            if (null == entry) {
                return;
            }
            StoreFile storeFile = entry.getValue();
            if (!storeFile.isClean()) {
                Map.Entry<Long, StoreFile> prevEntry;
                if (storeFile.flushPosition() == 0 && null != (prevEntry = this.storeFileMap.floorEntry(entry.getKey() - 1L))) {
                    prevEntry.getValue().force();
                }
                storeFile.flush();
            }
            if (this.flushPosition.get() < storeFile.position() + (long)storeFile.flushPosition()) {
                this.flushPosition.set(storeFile.position() + (long)storeFile.flushPosition());
            }
        }
    }

    private StoreFile createStoreFile(long position) {
        StoreFile storeFile = new LocalStoreFile(position, this.base, this.config.getFileHeaderSize(), this.bufferPool, this.config.getFileDataSize());
        StoreFile present = this.storeFileMap.putIfAbsent(position, storeFile);
        if (present != null) {
            storeFile = present;
        } else {
            this.checkDiskFreeSpace(this.base, this.config.getFileDataSize() + this.config.getFileHeaderSize());
        }
        return storeFile;
    }

    private void checkDiskFreeSpace(File file, long fileSize) {
        if (file.getFreeSpace() < fileSize) {
            throw new DiskFullException(file);
        }
    }

    public byte[] read(long position, int length) throws IOException {
        if (length == 0) {
            return new byte[0];
        }
        this.checkReadPosition(position);
        StoreFile storeFile = this.getStoreFile(position);
        if (null == storeFile) {
            return null;
        }
        int relPosition = (int)(position - storeFile.position());
        return storeFile.read(relPosition, length).array();
    }

    public Long readLong(long position) throws IOException {
        this.checkReadPosition(position);
        StoreFile storeFile = this.getStoreFile(position);
        if (null == storeFile) {
            return null;
        }
        int relPosition = (int)(position - storeFile.position());
        return storeFile.readLong(relPosition);
    }

    private StoreFile getStoreFile(long position) {
        Map.Entry<Long, StoreFile> storeFileEntry = this.storeFileMap.floorEntry(position);
        if (storeFileEntry == null) {
            return null;
        }
        return storeFileEntry.getValue();
    }

    private void checkReadPosition(long position) {
        long p = this.min();
        if (p > position) {
            throw new PositionUnderflowException(position, p);
        }
        p = this.max();
        if (position >= p) {
            throw new PositionOverflowException(position, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long compact(long givenMin) throws IOException {
        Object object = this.fileMapMutex;
        synchronized (object) {
            if (givenMin <= this.min()) {
                return 0L;
            }
            if (givenMin > this.flushPosition.get()) {
                throw new IllegalArgumentException(String.format("GivenMax %s should less than flush position %s!", ThreadSafeFormat.formatWithComma((long)givenMin), ThreadSafeFormat.formatWithComma((long)this.flushPosition.get())));
            }
            this.leftPosition.set(givenMin);
            Iterator iterator = this.storeFileMap.entrySet().iterator();
            long deleteSize = 0L;
            while (iterator.hasNext()) {
                long fileDataSize;
                Map.Entry entry = iterator.next();
                StoreFile storeFile = (StoreFile)entry.getValue();
                long start = (Long)entry.getKey();
                long l = fileDataSize = storeFile.hasPage() ? (long)storeFile.writePosition() : (long)storeFile.fileDataSize();
                if (start + fileDataSize > givenMin) break;
                iterator.remove();
                this.forceDeleteStoreFile(storeFile);
                deleteSize += fileDataSize;
            }
            return deleteSize;
        }
    }

    private void forceDeleteStoreFile(StoreFile storeFile) throws IOException {
        storeFile.forceUnload();
        File file = storeFile.file();
        if (file.exists()) {
            if (file.delete()) {
                this.logger.debug("File {} deleted.", (Object)file.getAbsolutePath());
            } else {
                throw new IOException(String.format("Delete file %s failed!", file.getAbsolutePath()));
            }
        }
    }

    public Path getBasePath() {
        return this.base.toPath();
    }

    @Override
    public void close() throws IOException {
        for (StoreFile storeFile : this.storeFileMap.values()) {
            storeFile.flush();
            storeFile.forceUnload();
        }
        this.bufferPool.removePreLoad(this.config.fileDataSize);
    }

    public Path getPath() {
        return this.getBasePath();
    }

    public long getFreeSpace() {
        return this.base.getFreeSpace();
    }

    public long getTotalSpace() {
        return this.base.getTotalSpace();
    }

    public String toString() {
        return "PositioningStore{flushPosition=" + this.flushPosition + ", writePosition(max)=" + this.writePosition + ", leftPosition(min)=" + this.leftPosition + '}';
    }

    public static class Config {
        static final int DEFAULT_FILE_HEADER_SIZE = 128;
        static final int DEFAULT_FILE_DATA_SIZE = 0x8000000;
        static final int DEFAULT_CACHED_FILE_CORE_COUNT = 0;
        static final int DEFAULT_CACHED_FILE_MAX_COUNT = 2;
        static final long DEFAULT_MAX_DIRTY_SIZE = 0L;
        static final String FILE_HEADER_SIZE_KEY = "file_header_size";
        static final String FILE_DATA_SIZE_KEY = "file_data_size";
        static final String CACHED_FILE_CORE_COUNT_KEY = "cached_file_core_count";
        static final String CACHED_FILE_MAX_COUNT_KEY = "cached_file_max_count";
        static final String MAX_DIRTY_SIZE_KEY = "max_dirty_size";
        private int fileHeaderSize;
        private int fileDataSize;
        private int cachedFileCoreCount;
        private int cachedFileMaxCount;
        private long maxDirtySize;

        int getFileHeaderSize() {
            return this.fileHeaderSize;
        }

        void setFileHeaderSize(int fileHeaderSize) {
            this.fileHeaderSize = fileHeaderSize;
        }

        int getFileDataSize() {
            return this.fileDataSize;
        }

        void setFileDataSize(int fileDataSize) {
            this.fileDataSize = fileDataSize;
        }

        int getCachedFileCoreCount() {
            return this.cachedFileCoreCount;
        }

        void setCachedFileCoreCount(int cachedFileCoreCount) {
            this.cachedFileCoreCount = cachedFileCoreCount;
        }

        int getCachedFileMaxCount() {
            return this.cachedFileMaxCount;
        }

        void setCachedFileMaxCount(int cachedFileMaxCount) {
            this.cachedFileMaxCount = cachedFileMaxCount;
        }

        public long getMaxDirtySize() {
            return this.maxDirtySize;
        }

        public void setMaxDirtySize(long maxDirtySize) {
            this.maxDirtySize = maxDirtySize;
        }
    }
}

