/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.persistence.local.lock;

import io.journalkeeper.persistence.LockablePersistence;
import io.journalkeeper.persistence.PersistenceLockedException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLock
implements LockablePersistence {
    private static final Logger logger = LoggerFactory.getLogger(FileLock.class);
    private final File lockFile;
    private FileChannel channel;
    private java.nio.channels.FileLock lock;

    public FileLock(Path lockPath) {
        this.lockFile = lockPath.toFile();
    }

    public void lock() throws IOException {
        if (!this.lockFile.getParentFile().isDirectory() && !this.lockFile.getParentFile().mkdirs()) {
            throw new IOException(String.format("Create directory %s failed!", this.lockFile.getParent()));
        }
        this.channel = new RandomAccessFile(this.lockFile, "rw").getChannel();
        this.lock = this.channel.tryLock();
        if (this.lock == null) {
            this.channel.close();
            throw new PersistenceLockedException(String.format("Failed to acquire file lock: %s, file is locked by other process!", this.lockFile.getAbsolutePath()));
        }
    }

    public void unlock() {
        try {
            if (this.lock != null) {
                this.lock.release();
                this.channel.close();
                if (!this.lockFile.delete()) {
                    logger.warn("Delete lock file {} failed.", (Object)this.lockFile.getAbsolutePath());
                }
            }
        }
        catch (IOException e) {
            logger.warn("Unlock file {} failed!", (Object)this.lockFile.getAbsoluteFile());
        }
    }
}

