/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.persistence.local.metadata;

import com.google.gson.Gson;
import io.journalkeeper.persistence.MetadataPersistence;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class JsonDoubleCopiesPersistence
implements MetadataPersistence {
    static final String FIRST_COPY = ".0.json";
    static final String SECOND_COPY = ".1.json";
    private static final Gson gson = new Gson();

    public <M> void save(Path path, M metadata) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        byte[] serialized = gson.toJson(metadata).getBytes(StandardCharsets.UTF_8);
        try {
            Files.write(this.getCopy(path, FIRST_COPY), serialized, new OpenOption[0]);
            Files.write(this.getCopy(path, SECOND_COPY), serialized, new OpenOption[0]);
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            // empty catch block
        }
    }

    Path getCopy(Path path, String copy) {
        return path.getParent().resolve(path.getFileName() + copy);
    }

    public <M> M load(Path path, Class<M> mClass) throws IOException {
        try {
            M m = this.tryParseFile(this.getCopy(path, FIRST_COPY), mClass);
            return null != m ? m : this.tryParseFile(this.getCopy(path, SECOND_COPY), mClass);
        }
        catch (Throwable ignored) {
            return this.tryParseFile(this.getCopy(path, SECOND_COPY), mClass);
        }
    }

    private <M> M tryParseFile(Path path, Class<M> mClass) throws IOException {
        return (M)gson.fromJson(new String(Files.readAllBytes(path), StandardCharsets.UTF_8), mClass);
    }
}

