/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import io.joynr.capabilities.CapabilityEntry;
import io.joynr.capabilities.ProviderQosPersisted;
import io.joynr.dispatcher.rpc.JoynrInterface;
import io.joynr.endpoints.AddressPersisted;
import io.joynr.endpoints.JoynrMessagingEndpointAddressPersisted;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import joynr.system.RoutingTypes.Address;
import joynr.types.CapabilityInformation;
import joynr.types.ProviderQos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Inheritance
@DiscriminatorColumn(name="cached", discriminatorType=DiscriminatorType.CHAR)
@DiscriminatorValue(value="N")
@Table(name="capabilities")
public class CapabilityEntryPersisted
implements CapabilityEntry,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(CapabilityEntryPersisted.class);
    @Id
    protected String participantId;
    protected String domain;
    protected String interfaceName;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="participantId", referencedColumnName="participantId")
    protected ProviderQosPersisted providerQos;
    @OneToMany(cascade={CascadeType.ALL}, targetEntity=AddressPersisted.class)
    @JoinColumn(name="participantId", referencedColumnName="participantId")
    protected List<AddressPersisted> endpointAddresses;
    protected long dateWhenRegistered;
    protected CapabilityEntry.Origin origin;

    public CapabilityEntryPersisted() {
        this.origin = CapabilityEntry.Origin.LOCAL;
    }

    public CapabilityEntryPersisted(String domain, String interfaceName, ProviderQos providerQos, String participantId, long dateWhenRegistered, AddressPersisted ... endpointAddresses) {
        this.domain = domain;
        this.interfaceName = interfaceName;
        this.providerQos = new ProviderQosPersisted(participantId, providerQos);
        this.participantId = participantId;
        this.dateWhenRegistered = dateWhenRegistered;
        this.origin = CapabilityEntry.Origin.LOCAL;
        this.endpointAddresses = new ArrayList<AddressPersisted>(Arrays.asList(endpointAddresses));
    }

    public <T extends JoynrInterface> CapabilityEntryPersisted(String domain, Class<T> providedInterface, ProviderQos providerQos, String participantId, long dateWhenRegistered, AddressPersisted ... endpointAddresses) {
        this(domain, "", providerQos, participantId, dateWhenRegistered, endpointAddresses);
        String name = null;
        String reason = "shadow field INTERFACE_NAME in your interface";
        try {
            name = (String)providedInterface.getField("INTERFACE_NAME").get(String.class);
        }
        catch (Exception e) {
            reason = reason + ": " + e.getMessage();
        }
        if (name == null) {
            logger.error("INTERFACE_NAME not set in class {}", (Object)providedInterface.getSimpleName());
            throw new IllegalArgumentException(reason);
        }
        this.interfaceName = name;
    }

    public CapabilityEntryPersisted(CapabilityInformation capabilityInformation) {
        this(capabilityInformation.getDomain(), capabilityInformation.getInterfaceName(), capabilityInformation.getProviderQos(), capabilityInformation.getParticipantId(), System.currentTimeMillis(), new JoynrMessagingEndpointAddressPersisted(capabilityInformation.getChannelId()));
    }

    public static CapabilityEntryPersisted fromCapabilityInformation(CapabilityInformation capInfo) {
        return new CapabilityEntryPersisted(capInfo.getDomain(), capInfo.getInterfaceName(), capInfo.getProviderQos(), capInfo.getParticipantId(), System.currentTimeMillis(), new JoynrMessagingEndpointAddressPersisted(capInfo.getChannelId()));
    }

    @CheckForNull
    public CapabilityInformation toCapabilityInformation() {
        String channelId = null;
        for (Address endpointAddress : this.getAddresses()) {
            if (!(endpointAddress instanceof JoynrMessagingEndpointAddressPersisted)) continue;
            channelId = ((JoynrMessagingEndpointAddressPersisted)endpointAddress).getChannelId();
            break;
        }
        if (channelId == null) {
            return null;
        }
        return new CapabilityInformation(this.getDomain(), this.getInterfaceName(), new ProviderQos(this.getProviderQos()), channelId, this.getParticipantId());
    }

    public ProviderQos getProviderQos() {
        return this.providerQos;
    }

    public List<Address> getAddresses() {
        return Collections.unmodifiableList(this.endpointAddresses);
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public long getDateWhenRegistered() {
        return this.dateWhenRegistered;
    }

    public void setDateWhenRegistered(long dateWhenRegistered) {
        this.dateWhenRegistered = dateWhenRegistered;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.dateWhenRegistered ^ this.dateWhenRegistered >>> 32);
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.endpointAddresses == null ? 0 : this.endpointAddresses.hashCode());
        result = 31 * result + (this.interfaceName == null ? 0 : this.interfaceName.hashCode());
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + (this.participantId == null ? 0 : this.participantId.hashCode());
        result = 31 * result + (this.providerQos == null ? 0 : this.providerQos.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CapabilityEntryPersisted other = (CapabilityEntryPersisted)obj;
        if (this.dateWhenRegistered != other.dateWhenRegistered) {
            return false;
        }
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.endpointAddresses == null ? other.endpointAddresses != null : !this.endpointAddresses.equals(other.endpointAddresses)) {
            return false;
        }
        if (this.interfaceName == null ? other.interfaceName != null : !this.interfaceName.equals(other.interfaceName)) {
            return false;
        }
        if (this.origin != other.origin) {
            return false;
        }
        if (this.participantId == null ? other.participantId != null : !this.participantId.equals(other.participantId)) {
            return false;
        }
        return !(this.providerQos == null ? other.providerQos != null : !this.providerQos.equals(other.providerQos));
    }

    public void setOrigin(CapabilityEntry.Origin remote) {
    }

    public void addEndpoint(Address endpointAddress) {
        if (endpointAddress instanceof AddressPersisted) {
            this.endpointAddresses.add((AddressPersisted)endpointAddress);
        }
    }
}

