/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.PersistService;
import io.joynr.capabilities.CapabilitiesProvisioning;
import io.joynr.capabilities.CapabilitiesStore;
import io.joynr.capabilities.CapabilityEntry;
import io.joynr.capabilities.CapabilityEntryPersisted;
import io.joynr.exceptions.JoynrCommunicationException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CapabilitiesStorePersisted
implements CapabilitiesStore {
    private static final Logger logger = LoggerFactory.getLogger(CapabilitiesStorePersisted.class);
    protected Provider<EntityManager> entityManagerProvider;
    private Object capsLock = new Object();

    @Inject
    public CapabilitiesStorePersisted(CapabilitiesProvisioning staticProvisioning, Provider<EntityManager> entityManagerProvider, PersistService persistService) {
        persistService.start();
        this.entityManagerProvider = entityManagerProvider;
        logger.debug("creating CapabilitiesStore {} with static provisioning", (Object)this);
        this.add(staticProvisioning.getCapabilityEntries());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(CapabilityEntry capabilityEntry) {
        if (!(capabilityEntry instanceof CapabilityEntryPersisted)) {
            return;
        }
        if (capabilityEntry.getDomain() == null || capabilityEntry.getInterfaceName() == null || capabilityEntry.getParticipantId() == null || capabilityEntry.getAddresses() == null || capabilityEntry.getAddresses().isEmpty()) {
            String message = "capabilityEntry being registered is not complete: " + capabilityEntry;
            logger.error(message);
            throw new JoynrCommunicationException(message);
        }
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        CapabilityEntryPersisted capabilityEntryFound = (CapabilityEntryPersisted)entityManager.find(CapabilityEntryPersisted.class, (Object)capabilityEntry.getParticipantId());
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            if (capabilityEntryFound != null) {
                entityManager.merge((Object)capabilityEntry);
            } else {
                entityManager.persist((Object)capabilityEntry);
            }
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            logger.error("unable to add capabilityEntry: {}, reason: {}", (Object)capabilityEntry, (Object)e.getMessage());
        }
    }

    public void add(Collection<? extends CapabilityEntry> entries) {
        if (entries != null) {
            for (CapabilityEntry capabilityEntry : entries) {
                this.add(capabilityEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String participantId) {
        boolean removedSuccessfully = false;
        Object object = this.capsLock;
        synchronized (object) {
            removedSuccessfully = this.removeCapabilityFromStore(participantId);
        }
        if (!removedSuccessfully) {
            logger.error("Could not find capability to remove with Id: {}", (Object)participantId);
        }
        return removedSuccessfully;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeCapabilityFromStore(String participantId) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        CapabilityEntryPersisted capabilityEntry = (CapabilityEntryPersisted)entityManager.find(CapabilityEntryPersisted.class, (Object)participantId);
        EntityTransaction transaction = entityManager.getTransaction();
        try {
            transaction.begin();
            entityManager.remove((Object)capabilityEntry);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            logger.error("unable to remove capability: {} reason: {}", (Object)participantId, (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public void remove(Collection<String> participantIds) {
        for (String participantId : participantIds) {
            this.remove(participantId);
        }
    }

    public Collection<CapabilityEntry> lookup(String domain, String interfaceName) {
        return this.lookup(domain, interfaceName, Long.MAX_VALUE);
    }

    @Transactional
    public Collection<CapabilityEntry> lookup(String domain, String interfaceName, long cacheMaxAge) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        String query = "select ce from CapabilityEntryPersisted ce inner join ce.providerQos qos where ce.participantId = qos.participantId and ce.domain=:domain and ce.interfaceName=:interfaceName";
        List capabilitiesList = entityManager.createQuery(query).setParameter("domain", (Object)domain).setParameter("interfaceName", (Object)interfaceName).getResultList();
        logger.debug("Capabilities found: {}", (Object)capabilitiesList.toString());
        return capabilitiesList;
    }

    @CheckForNull
    @Transactional
    public CapabilityEntry lookup(String participantId, long cacheMaxAge) {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        return (CapabilityEntry)entityManager.find(CapabilityEntryPersisted.class, (Object)participantId);
    }

    @Transactional
    public HashSet<CapabilityEntry> getAllCapabilities() {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        List allCapabilityEntries = entityManager.createQuery("Select capabilityEntry from CapabilityEntryPersisted capabilityEntry", CapabilityEntryPersisted.class).getResultList();
        return new HashSet<CapabilityEntry>(allCapabilityEntries);
    }

    public boolean hasCapability(@Nonnull CapabilityEntry capabilityEntry) {
        if (capabilityEntry instanceof CapabilityEntryPersisted) {
            EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
            CapabilityEntryPersisted searchingForCapabilityEntry = (CapabilityEntryPersisted)capabilityEntry;
            CapabilityEntryPersisted foundCapability = (CapabilityEntryPersisted)entityManager.find(CapabilityEntryPersisted.class, (Object)searchingForCapabilityEntry.participantId);
            return capabilityEntry.equals(foundCapability);
        }
        return false;
    }
}

