/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import io.joynr.capabilities.CustomParameterPersisted;
import java.io.Serializable;
import java.util.Arrays;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import joynr.types.CustomParameter;
import joynr.types.ProviderQos;
import joynr.types.ProviderScope;

@Entity
@Table(name="providerqos")
public class ProviderQosPersisted
extends ProviderQos
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String participantId;

    public ProviderQosPersisted() {
    }

    public ProviderQosPersisted(final String participantId, ProviderQos providerQos) {
        super(Collections2.transform(Arrays.asList(providerQos.getCustomParameters()), (Function)new Function<CustomParameter, CustomParameterPersisted>(){

            public CustomParameterPersisted apply(CustomParameter input) {
                return new CustomParameterPersisted(participantId, input);
            }
        }).toArray(new CustomParameter[providerQos.getCustomParameters().length]), providerQos.getProviderVersion(), providerQos.getPriority(), providerQos.getScope(), providerQos.getSupportsOnChangeSubscriptions());
        this.participantId = participantId;
    }

    @Id
    protected final String getParticipantId() {
        return this.participantId;
    }

    protected final void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    @Lob
    public CustomParameter[] getCustomParameters() {
        return super.getCustomParameters();
    }

    public void setCustomParameters(CustomParameter[] customParameters) {
        super.setCustomParameters(customParameters);
    }

    public Long getPriority() {
        return super.getPriority();
    }

    public void setPriority(Long priority) {
        super.setPriority(priority);
    }

    public Integer getProviderVersion() {
        return super.getProviderVersion();
    }

    public void setProviderVersion(Integer providerVersion) {
        super.setProviderVersion(providerVersion);
    }

    public ProviderScope getScope() {
        return super.getScope();
    }

    public void setScope(ProviderScope scope) {
        super.setScope(scope);
    }

    public Boolean getSupportsOnChangeSubscriptions() {
        return super.getSupportsOnChangeSubscriptions();
    }

    public void setSupportsOnChangeSubscriptions(Boolean supportsOnChangeSubscriptions) {
        super.setSupportsOnChangeSubscriptions(supportsOnChangeSubscriptions);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.participantId == null ? 0 : this.participantId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProviderQosPersisted other = (ProviderQosPersisted)obj;
        return !(this.participantId == null ? other.participantId != null : !this.participantId.equals(other.participantId));
    }
}

