/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities.directory;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.capabilities.CapabilityEntry;
import io.joynr.capabilities.CapabilityEntryPersisted;
import io.joynr.capabilities.InProcessCapabilitiesProvisioning;
import io.joynr.endpoints.JoynrMessagingEndpointAddressPersisted;
import java.util.ArrayList;
import java.util.Collection;
import joynr.system.RoutingTypes.Address;
import joynr.types.ProviderQos;
import joynr.types.ProviderScope;

public class DirectoryCapabilitiesProvisioning
extends InProcessCapabilitiesProvisioning {
    private String discoveryProviderParticipantId;
    private String systemServicesDomain;
    private String localChannelId;

    @Inject
    public DirectoryCapabilitiesProvisioning(@Named(value="joynr.messaging.discoveryproviderparticipantid") String discoveryProviderParticipantId, @Named(value="joynr.messaging.systemservicesdomain") String systemServicesDomain, @Named(value="joynr.messaging.discoveryprovideraddress") Address discoveryProviderAddress, @Named(value="joynr.messaging.channelid") String localChannelId) {
        super(discoveryProviderParticipantId, systemServicesDomain, discoveryProviderAddress);
        this.discoveryProviderParticipantId = discoveryProviderParticipantId;
        this.systemServicesDomain = systemServicesDomain;
        this.localChannelId = localChannelId;
    }

    public Collection<? extends CapabilityEntry> getCapabilityEntries() {
        ArrayList provisionedList = Lists.newArrayList();
        ProviderQos providerQos = new ProviderQos();
        providerQos.setScope(ProviderScope.LOCAL);
        provisionedList.add(new CapabilityEntryPersisted(this.systemServicesDomain, "system/Discovery", providerQos, this.discoveryProviderParticipantId, System.currentTimeMillis(), new JoynrMessagingEndpointAddressPersisted(this.localChannelId)));
        return provisionedList;
    }
}

