/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.joynr.capabilities.ProviderQosPersisted;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import joynr.types.GlobalDiscoveryEntry;
import joynr.types.ProviderQos;
import joynr.types.Version;

@Entity
@Table(name="discovery_entries")
public class GlobalDiscoveryEntryPersisted
extends GlobalDiscoveryEntry {
    private static final long serialVersionUID = 1L;
    private ProviderQosPersisted providerQosPersisted;
    @JsonProperty(value="clusterControllerId")
    private String clusterControllerId;

    public GlobalDiscoveryEntryPersisted() {
    }

    public GlobalDiscoveryEntryPersisted(GlobalDiscoveryEntry globalDiscoveryEntryObj, String clusterControllerId) {
        super(globalDiscoveryEntryObj);
        this.clusterControllerId = clusterControllerId;
        this.providerQosPersisted = new ProviderQosPersisted(globalDiscoveryEntryObj.getQos());
    }

    GlobalDiscoveryEntryPersisted(Version providerVersion, String domain, String interfaceName, String participantId, ProviderQos qos, long lastSeenDateMs, long expiryDateMs, String publicKeyId, String address, String clusterControllerId) {
        super(providerVersion, domain, interfaceName, participantId, qos, Long.valueOf(lastSeenDateMs), Long.valueOf(expiryDateMs), publicKeyId, address);
        this.clusterControllerId = clusterControllerId;
        this.providerQosPersisted = new ProviderQosPersisted(qos);
    }

    @Column
    public String getDomain() {
        return super.getDomain();
    }

    @Column
    public String getInterfaceName() {
        return super.getInterfaceName();
    }

    @Column
    @Id
    public String getParticipantId() {
        return super.getParticipantId();
    }

    @Column
    @Embedded
    public ProviderQosPersisted getProviderQosPersisted() {
        return this.providerQosPersisted;
    }

    public void setProviderQosPersisted(ProviderQosPersisted providerQosPersisted) {
        this.providerQosPersisted = providerQosPersisted;
        super.setQos(new ProviderQos((ProviderQos)providerQosPersisted));
    }

    @Column
    public Long getLastSeenDateMs() {
        return super.getLastSeenDateMs();
    }

    @Column
    public Long getExpiryDateMs() {
        return super.getExpiryDateMs();
    }

    @Column(length=4000)
    @Lob
    public String getAddress() {
        return super.getAddress();
    }

    @Column
    public String getPublicKeyId() {
        return super.getPublicKeyId();
    }

    @Column
    public Integer getMajorVersion() {
        return this.getProviderVersion().getMajorVersion();
    }

    public void setMajorVersion(Integer majorVersion) {
        this.getProviderVersion().setMajorVersion(majorVersion);
    }

    @Column
    public Integer getMinorVersion() {
        return this.getProviderVersion().getMinorVersion();
    }

    public void setMinorVersion(Integer minorVersion) {
        this.getProviderVersion().setMinorVersion(minorVersion);
    }

    @Column
    public String getClusterControllerId() {
        return this.clusterControllerId;
    }

    public void setClusterControllerId(String clusterControllerId) {
        this.clusterControllerId = clusterControllerId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GlobalDiscoveryEntryPersisted other = (GlobalDiscoveryEntryPersisted)((Object)obj);
        return !(this.clusterControllerId == null ? other.clusterControllerId != null : !this.clusterControllerId.equals(other.clusterControllerId));
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.clusterControllerId == null ? 0 : this.clusterControllerId.hashCode());
        return result;
    }
}

