/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities.directory;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapabilitiesDirectoryProperties {
    private final Properties config;
    public static final String CONFIG_FILE_NAME = "capabilitiesDirectory.properties";
    private Logger logger = LoggerFactory.getLogger(CapabilitiesDirectoryProperties.class);

    public CapabilitiesDirectoryProperties() {
        this.config = this.getConfigProperties();
    }

    private Properties getConfigProperties() {
        InputStream resourceStream;
        URL resource = this.getClass().getClassLoader().getResource(CONFIG_FILE_NAME);
        try {
            resourceStream = resource.openStream();
        }
        catch (IOException e) {
            this.logger.error("The configuration file could not be located" + resource.toString(), (Throwable)e);
            resourceStream = null;
        }
        Properties properties = new Properties();
        try {
            if (resourceStream != null) {
                properties.load(resourceStream);
            }
        }
        catch (IOException ex) {
            this.logger.error("Could not load the configuration file: {}", (Object)CONFIG_FILE_NAME, (Object)ex);
        }
        return properties;
    }

    @Inject
    public CapabilitiesDirectoryProperties(@Named(value="capabilitiesDirectoryConfig") Properties config) {
        if (config == null) {
            throw new IllegalArgumentException("The configuration properties cannot be null.");
        }
        this.config = config;
    }

    public String getMessagingBounceProxyUrl() {
        return this.config.getProperty("joynr.messaging.bounceproxyurl");
    }

    public String getMessagingCreateChannelRetryIntervalMs() {
        return this.config.getProperty("joynr.messaging.createchannelretryintervalms");
    }

    public String getMessagingSendMsgRetryIntervalMs() {
        return this.config.getProperty("joynr.messaging.sendmsgretryintervalms");
    }

    public String getMessagingSendProxyAddress() {
        return this.config.getProperty("joynr.messaging.sendProxyAddress");
    }

    public String getMessagingSendProxyPort() {
        return this.config.getProperty("joynr.messaging.sendProxyPort");
    }

    public String getCapabilitiesDirectoryChannelId() {
        return this.config.getProperty("joynr.capabilitiesDirectory.channelId");
    }

    public String getCapabilitiesDirectoryInterface() {
        return this.config.getProperty("joynr.capabilitiesDirectory.interface");
    }

    public String getCapabilitiesDirectoryDomain() {
        return this.config.getProperty("joynr.capabilitiesDirectory.domain");
    }

    public String getCapabilitiesClientRequestTimeout() {
        return this.config.getProperty("joynr.discovery.requesttimeout");
    }

    public String getMessagingLongPollRetryIntervalMs() {
        return this.config.getProperty("joynr.messaging.LongPollRetryIntervalMs");
    }

    public String getCapabilitiesDumpFile() {
        return this.config.getProperty("joynr.capabilitiesDirectory.dumpFile");
    }

    public Properties getProperties() {
        return this.config;
    }
}

