/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities.directory;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.joynr.arbitration.DiscoveryQos;
import io.joynr.capabilities.CapabilitiesStore;
import io.joynr.capabilities.CapabilityEntry;
import java.util.Collection;
import java.util.List;
import joynr.infrastructure.GlobalCapabilitiesDirectoryAbstractProvider;
import joynr.types.CapabilityInformation;
import joynr.types.ProviderQos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CapabilitiesDirectoryImpl
extends GlobalCapabilitiesDirectoryAbstractProvider {
    private static final Logger logger = LoggerFactory.getLogger(CapabilitiesDirectoryImpl.class);
    private CapabilitiesStore capabiltiesStore;

    @Inject
    public CapabilitiesDirectoryImpl(CapabilitiesStore capabiltiesStore) {
        this.capabiltiesStore = capabiltiesStore;
    }

    public void add(CapabilityInformation capabilityInformation) {
        CapabilityEntry capabilityEntry = this.capabilityInformation2Entry(capabilityInformation);
        logger.debug("registered capability: {}", (Object)capabilityEntry);
        this.capabiltiesStore.add(capabilityEntry);
    }

    private CapabilityEntry capabilityInformation2Entry(CapabilityInformation capabilityInformation) {
        return CapabilityEntry.fromCapabilityInformation((CapabilityInformation)capabilityInformation);
    }

    public void add(List<CapabilityInformation> capabilitiesInformation) {
        List capabilityEntries = Lists.newArrayList();
        for (CapabilityInformation capInfo : capabilitiesInformation) {
            capabilityEntries.add(this.capabilityInformation2Entry(capInfo));
        }
        logger.debug("registered capabilities: interface {}", (Object)capabilityEntries.toString());
        this.capabiltiesStore.add((Collection)capabilityEntries);
    }

    public void remove(String participantId) {
        logger.debug("removed capability with participantId: {}", (Object)participantId);
        this.capabiltiesStore.remove(participantId);
    }

    public void remove(List<String> capabilities) {
        List capabilityEntries = Lists.newArrayList();
        logger.debug("Removing capabilities: Capabilities {}", (Object)capabilityEntries);
        this.capabiltiesStore.remove(capabilities);
    }

    public List<CapabilityInformation> lookup(String domain, String interfaceName) {
        logger.debug("Searching channels for domain: " + domain + " interfaceName: " + interfaceName + " {}");
        List capabilityInformationList = Lists.newArrayList();
        Collection entryCollection = this.capabiltiesStore.lookup(domain, interfaceName);
        for (CapabilityEntry entry : entryCollection) {
            capabilityInformationList.add(entry.toCapabilityInformation());
        }
        return capabilityInformationList;
    }

    public CapabilityInformation lookup(String forParticipantId) {
        logger.debug("Searching capabilities for participantId: {}", (Object)forParticipantId);
        CapabilityEntry capEntry = this.capabiltiesStore.lookup(forParticipantId, DiscoveryQos.NO_FILTER);
        if (capEntry == null) {
            return null;
        }
        return capEntry.toCapabilityInformation();
    }

    public ProviderQos getProviderQos() {
        return this.providerQos;
    }
}

