/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities.directory;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.joynr.arbitration.DiscoveryQos;
import io.joynr.capabilities.CapabilitiesStore;
import io.joynr.capabilities.CapabilityEntry;
import io.joynr.capabilities.CapabilityEntryPersisted;
import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.DeferredVoid;
import io.joynr.provider.Promise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import joynr.infrastructure.GlobalCapabilitiesDirectoryAbstractProvider;
import joynr.infrastructure.GlobalCapabilitiesDirectoryProvider;
import joynr.types.CapabilityInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CapabilitiesDirectoryImpl
extends GlobalCapabilitiesDirectoryAbstractProvider {
    private static final Logger logger = LoggerFactory.getLogger(CapabilitiesDirectoryImpl.class);
    private CapabilitiesStore capabiltiesStore;

    @Inject
    public CapabilitiesDirectoryImpl(CapabilitiesStore capabiltiesStore) {
        this.capabiltiesStore = capabiltiesStore;
    }

    public Promise<DeferredVoid> add(CapabilityInformation capabilityInformation) {
        DeferredVoid deferred = new DeferredVoid();
        CapabilityEntryPersisted capabilityEntry = new CapabilityEntryPersisted(capabilityInformation);
        logger.debug("registered capability: {}", (Object)capabilityEntry);
        this.capabiltiesStore.add((CapabilityEntry)capabilityEntry);
        deferred.resolve();
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DeferredVoid> add(List<CapabilityInformation> capabilitiesInformation) {
        DeferredVoid deferred = new DeferredVoid();
        ArrayList capabilityEntries = Lists.newArrayList();
        for (CapabilityInformation capInfo : capabilitiesInformation) {
            capabilityEntries.add(new CapabilityEntryPersisted(capInfo));
        }
        logger.debug("registered capabilities: interface {}", (Object)((Object)capabilityEntries).toString());
        this.capabiltiesStore.add((Collection)capabilityEntries);
        deferred.resolve();
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DeferredVoid> remove(String participantId) {
        DeferredVoid deferred = new DeferredVoid();
        logger.debug("removed capability with participantId: {}", (Object)participantId);
        this.capabiltiesStore.remove(participantId);
        deferred.resolve();
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DeferredVoid> remove(List<String> capabilities) {
        DeferredVoid deferred = new DeferredVoid();
        ArrayList capabilityEntries = Lists.newArrayList();
        logger.debug("Removing capabilities: Capabilities {}", (Object)capabilityEntries);
        this.capabiltiesStore.remove(capabilities);
        deferred.resolve();
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalCapabilitiesDirectoryProvider.Lookup1Deferred> lookup(String domain, String interfaceName) {
        GlobalCapabilitiesDirectoryProvider.Lookup1Deferred deferred = new GlobalCapabilitiesDirectoryProvider.Lookup1Deferred();
        logger.debug("Searching channels for domain: " + domain + " interfaceName: " + interfaceName + " {}");
        ArrayList capabilityInformationList = Lists.newArrayList();
        Collection entryCollection = this.capabiltiesStore.lookup(domain, interfaceName);
        for (CapabilityEntry entry : entryCollection) {
            capabilityInformationList.add(entry.toCapabilityInformation());
        }
        deferred.resolve((List)capabilityInformationList);
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalCapabilitiesDirectoryProvider.Lookup2Deferred> lookup(String forParticipantId) {
        GlobalCapabilitiesDirectoryProvider.Lookup2Deferred deferred = new GlobalCapabilitiesDirectoryProvider.Lookup2Deferred();
        logger.debug("Searching capabilities for participantId: {}", (Object)forParticipantId);
        CapabilityEntry capEntry = this.capabiltiesStore.lookup(forParticipantId, DiscoveryQos.NO_FILTER.getCacheMaxAge());
        if (capEntry == null) {
            deferred.resolve(null);
        } else {
            deferred.resolve(capEntry.toCapabilityInformation());
        }
        return new Promise((AbstractDeferred)deferred);
    }
}

