/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.PersistService;
import io.joynr.capabilities.CapabilitiesProvisioning;
import io.joynr.capabilities.DiscoveryEntryStore;
import io.joynr.capabilities.GlobalDiscoveryEntryPersisted;
import io.joynr.exceptions.JoynrCommunicationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import joynr.types.DiscoveryEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DiscoveryEntryStorePersisted
implements DiscoveryEntryStore {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryEntryStorePersisted.class);
    private EntityManager entityManager;
    private Object capsLock = new Object();

    @Inject
    public DiscoveryEntryStorePersisted(CapabilitiesProvisioning staticProvisioning, Provider<EntityManager> entityManagerProvider, PersistService persistService) {
        persistService.start();
        this.entityManager = (EntityManager)entityManagerProvider.get();
        logger.debug("creating CapabilitiesStore {} with static provisioning", (Object)this);
    }

    public synchronized void add(DiscoveryEntry discoveryEntry) {
        logger.debug("adding discovery entry: {}", (Object)discoveryEntry);
        if (!(discoveryEntry instanceof GlobalDiscoveryEntryPersisted)) {
            return;
        }
        GlobalDiscoveryEntryPersisted globalDiscoveryEntry = (GlobalDiscoveryEntryPersisted)discoveryEntry;
        if (globalDiscoveryEntry.getDomain() == null || globalDiscoveryEntry.getInterfaceName() == null || globalDiscoveryEntry.getParticipantId() == null || globalDiscoveryEntry.getAddress() == null) {
            String message = "discoveryEntry being registered is not complete: " + discoveryEntry;
            logger.error(message);
            throw new JoynrCommunicationException(message);
        }
        GlobalDiscoveryEntryPersisted discoveryEntryFound = (GlobalDiscoveryEntryPersisted)((Object)this.entityManager.find(GlobalDiscoveryEntryPersisted.class, (Object)discoveryEntry.getParticipantId()));
        EntityTransaction transaction = this.entityManager.getTransaction();
        try {
            transaction.begin();
            if (discoveryEntryFound != null) {
                this.entityManager.merge((Object)discoveryEntry);
            } else {
                this.entityManager.persist((Object)discoveryEntry);
            }
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            logger.error("unable to add discoveryEntry: " + discoveryEntry, (Throwable)e);
        }
    }

    public void add(Collection<? extends DiscoveryEntry> entries) {
        if (entries != null) {
            for (DiscoveryEntry discoveryEntry : entries) {
                this.add(discoveryEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String participantId) {
        boolean removedSuccessfully = false;
        Object object = this.capsLock;
        synchronized (object) {
            removedSuccessfully = this.removeCapabilityFromStore(participantId);
        }
        if (!removedSuccessfully) {
            logger.error("Could not find capability to remove with Id: {}", (Object)participantId);
        }
        return removedSuccessfully;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeCapabilityFromStore(String participantId) {
        GlobalDiscoveryEntryPersisted discoveryEntry = (GlobalDiscoveryEntryPersisted)((Object)this.entityManager.find(GlobalDiscoveryEntryPersisted.class, (Object)participantId));
        EntityTransaction transaction = this.entityManager.getTransaction();
        try {
            transaction.begin();
            this.entityManager.remove((Object)discoveryEntry);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            logger.error("unable to remove capability: " + participantId, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public void remove(Collection<String> participantIds) {
        for (String participantId : participantIds) {
            this.remove(participantId);
        }
    }

    public Collection<DiscoveryEntry> lookup(String[] domains, String interfaceName) {
        return this.lookup(domains, interfaceName, Long.MAX_VALUE);
    }

    public Collection<DiscoveryEntry> lookup(String[] domains, String interfaceName, long cacheMaxAge) {
        String query = "from GlobalDiscoveryEntryPersisted where domain=:domain and interfaceName=:interfaceName";
        ArrayList<DiscoveryEntry> result = new ArrayList<DiscoveryEntry>();
        for (String domain : domains) {
            List capabilitiesList = this.entityManager.createQuery(query).setParameter("domain", (Object)domain).setParameter("interfaceName", (Object)interfaceName).getResultList();
            result.addAll(capabilitiesList);
        }
        logger.debug("looked up {}, {}, {} and found {}", new Object[]{Arrays.toString(domains), interfaceName, cacheMaxAge, result});
        return result;
    }

    @CheckForNull
    public DiscoveryEntry lookup(String participantId, long cacheMaxAge) {
        DiscoveryEntry result = (DiscoveryEntry)this.entityManager.find(GlobalDiscoveryEntryPersisted.class, (Object)participantId);
        logger.debug("looked up {}, {} and found {}", new Object[]{participantId, cacheMaxAge, result});
        return result;
    }

    public Set<DiscoveryEntry> getAllDiscoveryEntries() {
        List allCapabilityEntries = this.entityManager.createQuery("Select discoveryEntry from GlobalDiscoveryEntryPersisted discoveryEntry", GlobalDiscoveryEntryPersisted.class).getResultList();
        HashSet<DiscoveryEntry> result = new HashSet<DiscoveryEntry>(allCapabilityEntries);
        logger.debug("Retrieved all discovery entries: {}", result);
        return result;
    }

    public boolean hasDiscoveryEntry(@Nonnull DiscoveryEntry discoveryEntry) {
        if (discoveryEntry instanceof GlobalDiscoveryEntryPersisted) {
            GlobalDiscoveryEntryPersisted searchingForDiscoveryEntry = (GlobalDiscoveryEntryPersisted)discoveryEntry;
            GlobalDiscoveryEntryPersisted foundCapability = (GlobalDiscoveryEntryPersisted)((Object)this.entityManager.find(GlobalDiscoveryEntryPersisted.class, (Object)searchingForDiscoveryEntry.getParticipantId()));
            return discoveryEntry.equals((Object)foundCapability);
        }
        return false;
    }

    public void touch(String clusterControllerId) {
        String query = "from GlobalDiscoveryEntryPersisted where clusterControllerId=:clusterControllerId";
        EntityTransaction transaction = this.entityManager.getTransaction();
        try {
            transaction.begin();
            List capabilitiesList = this.entityManager.createQuery(query).setParameter("clusterControllerId", (Object)clusterControllerId).getResultList();
            for (DiscoveryEntry discoveryEntry : capabilitiesList) {
                logger.trace("  --> BEFORE entry {} last seen {}", (Object)discoveryEntry.getParticipantId(), (Object)discoveryEntry.getLastSeenDateMs());
                ((GlobalDiscoveryEntryPersisted)discoveryEntry).setLastSeenDateMs(System.currentTimeMillis());
                logger.trace("  --> AFTER  entry {} last seen {}", (Object)discoveryEntry.getParticipantId(), (Object)discoveryEntry.getLastSeenDateMs());
            }
            transaction.commit();
        }
        catch (RuntimeException e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            logger.error("Error updating last seen date for cluster controller with ID {}", (Object)clusterControllerId, (Object)e);
        }
    }
}

