/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities.directory;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.joynr.arbitration.DiscoveryQos;
import io.joynr.capabilities.CapabilityUtils;
import io.joynr.capabilities.DiscoveryEntryStore;
import io.joynr.capabilities.GlobalDiscoveryEntryPersisted;
import io.joynr.capabilities.directory.Persisted;
import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.DeferredVoid;
import io.joynr.provider.Promise;
import java.util.Arrays;
import java.util.Collection;
import joynr.exceptions.ProviderRuntimeException;
import joynr.infrastructure.GlobalCapabilitiesDirectoryAbstractProvider;
import joynr.infrastructure.GlobalCapabilitiesDirectoryProvider;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.ChannelAddress;
import joynr.system.RoutingTypes.MqttAddress;
import joynr.types.DiscoveryEntry;
import joynr.types.GlobalDiscoveryEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CapabilitiesDirectoryImpl
extends GlobalCapabilitiesDirectoryAbstractProvider {
    private static final Logger logger = LoggerFactory.getLogger(CapabilitiesDirectoryImpl.class);
    private DiscoveryEntryStore discoveryEntryStore;

    @Inject
    public CapabilitiesDirectoryImpl(@Persisted DiscoveryEntryStore discoveryEntryStore) {
        this.discoveryEntryStore = discoveryEntryStore;
    }

    public Promise<DeferredVoid> add(GlobalDiscoveryEntry globalDiscoveryEntry) {
        String clusterControllerId;
        DeferredVoid deferred = new DeferredVoid();
        Promise promise = new Promise((AbstractDeferred)deferred);
        Address address = CapabilityUtils.getAddressFromGlobalDiscoveryEntry((GlobalDiscoveryEntry)globalDiscoveryEntry);
        if (address instanceof MqttAddress) {
            clusterControllerId = ((MqttAddress)address).getTopic();
        } else if (address instanceof ChannelAddress) {
            clusterControllerId = ((ChannelAddress)address).getChannelId();
        } else {
            deferred.reject(new ProviderRuntimeException(""));
            return promise;
        }
        GlobalDiscoveryEntryPersisted discoveryEntry = new GlobalDiscoveryEntryPersisted(globalDiscoveryEntry, clusterControllerId);
        logger.debug("registered discovery entry: {}", (Object)discoveryEntry);
        this.discoveryEntryStore.add((DiscoveryEntry)discoveryEntry);
        deferred.resolve();
        return promise;
    }

    public Promise<DeferredVoid> add(GlobalDiscoveryEntry[] globalDiscoveryEntries) {
        DeferredVoid deferred = new DeferredVoid();
        for (GlobalDiscoveryEntry globalDiscoveryEntry : globalDiscoveryEntries) {
            this.add(globalDiscoveryEntry);
        }
        deferred.resolve();
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DeferredVoid> remove(String participantId) {
        DeferredVoid deferred = new DeferredVoid();
        logger.debug("removed discovery entry with participantId: {}", (Object)participantId);
        this.discoveryEntryStore.remove(participantId);
        deferred.resolve();
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DeferredVoid> remove(String[] participantIds) {
        DeferredVoid deferred = new DeferredVoid();
        this.discoveryEntryStore.remove(Arrays.asList(participantIds));
        deferred.resolve();
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalCapabilitiesDirectoryProvider.Lookup1Deferred> lookup(String[] domains, String interfaceName) {
        GlobalCapabilitiesDirectoryProvider.Lookup1Deferred deferred = new GlobalCapabilitiesDirectoryProvider.Lookup1Deferred();
        logger.debug("Searching channels for domains: {} interfaceName: {}", (Object)domains, (Object)interfaceName);
        Collection discoveryEntries = this.discoveryEntryStore.lookup(domains, interfaceName);
        GlobalDiscoveryEntry[] globalDiscoveryEntries = new GlobalDiscoveryEntry[discoveryEntries.size()];
        int index = 0;
        for (DiscoveryEntry discoveryEntry : discoveryEntries) {
            globalDiscoveryEntries[index] = new GlobalDiscoveryEntry((GlobalDiscoveryEntry)discoveryEntry);
            ++index;
        }
        deferred.resolve(globalDiscoveryEntries);
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalCapabilitiesDirectoryProvider.Lookup2Deferred> lookup(String forParticipantId) {
        GlobalCapabilitiesDirectoryProvider.Lookup2Deferred deferred = new GlobalCapabilitiesDirectoryProvider.Lookup2Deferred();
        logger.debug("Searching discovery entries for participantId: {}", (Object)forParticipantId);
        DiscoveryEntry discoveryEntry = this.discoveryEntryStore.lookup(forParticipantId, DiscoveryQos.NO_FILTER.getCacheMaxAgeMs());
        if (discoveryEntry == null) {
            deferred.resolve(null);
        } else {
            deferred.resolve((GlobalDiscoveryEntry)discoveryEntry);
        }
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<DeferredVoid> touch(String clusterControllerId) {
        DeferredVoid deferred = new DeferredVoid();
        this.discoveryEntryStore.touch(clusterControllerId);
        deferred.resolve();
        return new Promise((AbstractDeferred)deferred);
    }
}

