/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.discovery.jee;

import com.google.common.collect.Sets;
import io.joynr.capabilities.CapabilityUtils;
import io.joynr.capabilities.GlobalDiscoveryEntryPersisted;
import io.joynr.jeeintegration.api.ServiceProvider;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.transaction.Transactional;
import joynr.infrastructure.GlobalCapabilitiesDirectorySync;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.ChannelAddress;
import joynr.system.RoutingTypes.MqttAddress;
import joynr.types.GlobalDiscoveryEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@ServiceProvider(serviceInterface=GlobalCapabilitiesDirectorySync.class)
@Transactional
public class GlobalCapabilitiesDirectoryEjb
implements GlobalCapabilitiesDirectorySync {
    private static final Logger logger = LoggerFactory.getLogger(GlobalCapabilitiesDirectoryEjb.class);
    private EntityManager entityManager;

    @Inject
    public GlobalCapabilitiesDirectoryEjb(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void add(GlobalDiscoveryEntry[] globalDiscoveryEntries) {
        for (GlobalDiscoveryEntry entry : globalDiscoveryEntries) {
            if (entry != null) {
                this.add(entry);
                continue;
            }
            logger.trace("Ignoring null entry passed in as part of array.");
        }
    }

    public void add(GlobalDiscoveryEntry globalDiscoveryEntry) {
        logger.debug("Adding global discovery entry {}", (Object)globalDiscoveryEntry);
        Address address = CapabilityUtils.getAddressFromGlobalDiscoveryEntry((GlobalDiscoveryEntry)globalDiscoveryEntry);
        String clusterControllerId = address instanceof MqttAddress ? ((MqttAddress)address).getTopic() : (address instanceof ChannelAddress ? ((ChannelAddress)address).getChannelId() : String.valueOf(address));
        GlobalDiscoveryEntryPersisted entity = new GlobalDiscoveryEntryPersisted(globalDiscoveryEntry, clusterControllerId);
        GlobalDiscoveryEntryPersisted persisted = (GlobalDiscoveryEntryPersisted)this.entityManager.find(GlobalDiscoveryEntryPersisted.class, (Object)entity.getParticipantId());
        if (persisted == null) {
            this.entityManager.persist((Object)entity);
        } else {
            this.entityManager.merge((Object)entity);
        }
    }

    public GlobalDiscoveryEntry[] lookup(String[] domains, String interfaceName) {
        logger.debug("Looking up global discovery entries for domains {} and interface name {}", (Object)domains, (Object)interfaceName);
        String queryString = "from GlobalDiscoveryEntryPersisted gdep where gdep.domain in :domains and gdep.interfaceName = :interfaceName";
        List queryResult = this.entityManager.createQuery(queryString, GlobalDiscoveryEntryPersisted.class).setParameter("domains", (Object)Sets.newHashSet((Object[])domains)).setParameter("interfaceName", (Object)interfaceName).getResultList();
        logger.debug("Found discovery entries: {}", (Object)queryResult);
        return queryResult.stream().map(entry -> new GlobalDiscoveryEntry((GlobalDiscoveryEntry)entry)).collect(Collectors.toSet()).toArray(new GlobalDiscoveryEntry[queryResult.size()]);
    }

    public GlobalDiscoveryEntry lookup(String participantId) {
        logger.debug("Looking up global discovery entry for participant ID {}", (Object)participantId);
        GlobalDiscoveryEntryPersisted queryResult = (GlobalDiscoveryEntryPersisted)this.entityManager.find(GlobalDiscoveryEntryPersisted.class, (Object)participantId);
        logger.debug("Found entry {}", (Object)queryResult);
        return queryResult == null ? null : new GlobalDiscoveryEntry((GlobalDiscoveryEntry)queryResult);
    }

    public void remove(String[] participantIds) {
        logger.debug("Removing global discovery entries with IDs {}", (Object)Arrays.toString(participantIds));
        String queryString = "delete from GlobalDiscoveryEntryPersisted gdep where gdep.participantId in :participantIds";
        int deletedCount = this.entityManager.createQuery(queryString, GlobalDiscoveryEntryPersisted.class).setParameter("participantIds", (Object)Sets.newHashSet((Object[])participantIds)).executeUpdate();
        logger.debug("Deleted {} entries (number of IDs passed in {})", (Object)deletedCount, (Object)participantIds.length);
    }

    public void remove(String participantId) {
        this.remove(new String[]{participantId});
    }

    public void touch(String clusterControllerId) {
        logger.debug("Touch called. Updating discovery entries from cluster controller with id: " + clusterControllerId);
        String queryString = "select gdep from GlobalDiscoveryEntryPersisted gdep where gdep.clusterControllerId = :clusterControllerId";
        long now = System.currentTimeMillis();
        TypedQuery query = this.entityManager.createQuery(queryString, GlobalDiscoveryEntryPersisted.class);
        query.setParameter("clusterControllerId", (Object)clusterControllerId);
        for (GlobalDiscoveryEntryPersisted globalDiscoveryEntryPersisted : query.getResultList()) {
            globalDiscoveryEntryPersisted.setLastSeenDateMs(Long.valueOf(now));
        }
    }
}

