/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.discovery;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Inject;
import io.joynr.capabilities.DiscoveryEntryStore;
import io.joynr.capabilities.directory.Persisted;
import io.joynr.servlet.JoynrWebServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import joynr.types.DiscoveryEntry;
import joynr.types.ProviderScope;

@Singleton
@JoynrWebServlet(value="/capabilities/")
public class DiscoveryInformationServlet
extends HttpServlet {
    private static final long serialVersionUID = 8839103126167589803L;
    private final transient DiscoveryEntryStore discoveryEntryStore;
    private final transient Gson gson = new GsonBuilder().create();

    @Inject
    public DiscoveryInformationServlet(@Persisted DiscoveryEntryStore discoveryEntryStore) {
        this.discoveryEntryStore = discoveryEntryStore;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out;
        response.setContentType("text/html");
        try {
            out = response.getWriter();
        }
        catch (Exception e) {
            this.log("error getting writer", (Throwable)e);
            return;
        }
        HashSet<DiscoveryEntry> globalDiscoveryEntries = new HashSet<DiscoveryEntry>();
        Set allDiscoveryEntries = this.discoveryEntryStore.getAllDiscoveryEntries();
        for (DiscoveryEntry discoveryEntry : allDiscoveryEntries) {
            if (discoveryEntry.getQos().getScope() != ProviderScope.GLOBAL) continue;
            try {
                globalDiscoveryEntries.add(discoveryEntry);
            }
            catch (Exception e) {
                this.log("error adding channel information", (Throwable)e);
            }
        }
        out.println(this.gson.toJson(globalDiscoveryEntries));
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String queryString = request.getQueryString();
        String[] query = queryString.split("=");
        boolean removed = false;
        if (query.length > 1) {
            removed = this.discoveryEntryStore.remove(query[1]);
        }
        response.setStatus(200);
        try {
            PrintWriter out = response.getWriter();
            if (removed) {
                out.println("OK");
            } else {
                out.println("NOK");
            }
        }
        catch (Exception e) {
            this.log("error getting writer", (Throwable)e);
        }
    }

    public void destroy() {
    }
}

