/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatcher;

import com.google.common.util.concurrent.Futures;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.dispatcher.ServletMessageReceiver;
import io.joynr.messaging.IServletMessageReceivers;
import io.joynr.messaging.MessageArrivedListener;
import io.joynr.messaging.ReceiverStatusListener;
import io.joynr.messaging.http.operation.LongPollingMessageReceiver;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import joynr.JoynrMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ServletMessageReceiverImpl
implements ServletMessageReceiver {
    private static final Logger logger = LoggerFactory.getLogger(ServletMessageReceiverImpl.class);
    private MessageArrivedListener messageListener;
    private final String channelId;
    private boolean started;
    private LongPollingMessageReceiver longPollingReceiver;
    private int servletShutdownTimeout_ms;
    private boolean skipLongPollForDeregistration = false;

    @Inject
    public ServletMessageReceiverImpl(@Named(value="joynr.messaging.channelid") String channelId, LongPollingMessageReceiver longPollingReceiver, IServletMessageReceivers receivers, @Named(value="joynr.servlet.context.root") String contextRoot, @Named(value="joynr.servlet.shutdown.timeout") int servletShutdownTimeout_ms) {
        this.channelId = channelId;
        this.longPollingReceiver = longPollingReceiver;
        this.servletShutdownTimeout_ms = servletShutdownTimeout_ms;
        this.started = false;
        receivers.registerServletMessageReceiver((ServletMessageReceiver)this, channelId);
    }

    @Inject(optional=true)
    public void setSkipLongPollForDeregistration(@Named(value="joynr.servlet.skiplongpollderegistration") boolean skipLongPollForDeregistration) {
        this.skipLongPollForDeregistration = skipLongPollForDeregistration;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void shutdown(boolean clear) {
    }

    public boolean deleteChannel() {
        return false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void receive(JoynrMessage message) {
        if (message != null) {
            logger.debug("\r\n<<<<<<<< ARRIVED ON CHANNEL: " + this.channelId + " messageId: {}\r\n{}", (Object)message.getId(), (Object)message);
            this.messageListener.messageArrived(message);
        } else {
            logger.warn("ServletMessageReceiver CHANNEL: {} message was null", (Object)this.channelId);
        }
    }

    public void onError(JoynrMessage message, Throwable error) {
        if (this.messageListener == null) {
            logger.error("\r\n!!!! Dropped Message {}", (Object)message, (Object)error);
        } else {
            this.messageListener.error(message, error);
        }
    }

    public void suspend() {
    }

    public void resume() {
    }

    public boolean isReady() {
        return this.messageListener != null;
    }

    public boolean switchToLongPolling() {
        if (this.skipLongPollForDeregistration) {
            logger.info("not using long poll for deregistration");
            return true;
        }
        try {
            Future startReceiver = this.longPollingReceiver.start(this.messageListener, new ReceiverStatusListener[0]);
            startReceiver.get(this.servletShutdownTimeout_ms, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.debug("error switching to long polling while shutting down servlet.", (Throwable)e);
            return false;
        }
        logger.debug("switched to long polling.");
        return true;
    }

    public Future<Void> start(MessageArrivedListener registerMessageListener, ReceiverStatusListener ... statusListeners) {
        if (registerMessageListener == null) {
            throw new IllegalStateException();
        }
        this.messageListener = registerMessageListener;
        this.started = true;
        for (ReceiverStatusListener receiverStatusListener : statusListeners) {
            receiverStatusListener.receiverStarted();
        }
        return Futures.immediateFuture(null);
    }
}

