/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.joynr.communications.exceptions.JoynrHttpException;
import io.joynr.dispatcher.ServletMessageReceiver;
import io.joynr.messaging.IServletMessageReceivers;
import io.joynr.messaging.JsonMessageSerializerModule;
import io.joynr.messaging.datatypes.JoynrErrorCode;
import io.joynr.messaging.datatypes.JoynrMessagingErrorCode;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import joynr.JoynrMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/channels")
public class MessagingService {
    private static final Logger log = LoggerFactory.getLogger(MessagingService.class);
    private static final Injector injector = Guice.createInjector((Module[])new Module[]{new JsonMessageSerializerModule()});
    private static final ObjectMapper objectMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
    @Context
    UriInfo ui;
    private final IServletMessageReceivers messageReceivers;

    @Inject
    public MessagingService(IServletMessageReceivers messageReceivers) {
        this.messageReceivers = messageReceivers;
    }

    @GET
    @Produces(value={"application/json"})
    public GenericEntity<Collection<ServletMessageReceiver>> listChannels() {
        try {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        catch (Exception e) {
            log.error("GET channels listChannels: error: {}", (Object)e.getMessage(), (Object)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Consumes(value={"text/plain"})
    @Path(value="/{ccid: [A-Z,a-z,0-9,_,\\-,\\.]+}/messageWithoutContentType")
    public Response postMessageWithoutContentType(@PathParam(value="ccid") String ccid, String messageString) throws IOException, JsonParseException, JsonMappingException {
        JoynrMessage message = (JoynrMessage)objectMapper.readValue(messageString, JoynrMessage.class);
        return this.postMessage(ccid, message);
    }

    @POST
    @Path(value="/{channelId: [A-Z,a-z,0-9,_,\\-,\\.]+}/message")
    @Produces(value={"application/json"})
    public Response postMessage(@PathParam(value="channelId") String channelId, JoynrMessage message) {
        try {
            log.debug("POST message to channel: " + channelId + " message: " + message);
            if (channelId == null) {
                log.error("POST message to channel: NULL. message: {} dropped because: channel Id was not set", (Object)message);
                throw new JoynrHttpException(Response.Status.BAD_REQUEST, (JoynrErrorCode)JoynrMessagingErrorCode.JOYNRMESSAGINGERROR_CHANNELNOTSET);
            }
            if (message.getExpiryDate() == 0L) {
                log.error("POST message to channel: {} message: {} dropped because: TTL not set", (Object)channelId, (Object)message);
                throw new JoynrHttpException(Response.Status.BAD_REQUEST, (JoynrErrorCode)JoynrMessagingErrorCode.JOYNRMESSAGINGERROR_EXPIRYDATENOTSET);
            }
            ServletMessageReceiver messageReceiver = this.messageReceivers.getServletMessageReceiver(channelId);
            if (messageReceiver == null) {
                log.error("POST message to channel: {} message: {} no receiver for the given channel", (Object)channelId, (Object)message);
                return Response.noContent().build();
            }
            log.trace("passing off message to messageReceiver: " + channelId);
            messageReceiver.receive(message);
            URI location = this.ui.getBaseUriBuilder().path("messages/" + message.getId()).build(new Object[0]);
            return Response.created((URI)location).build();
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("POST message to channel: " + channelId + "error: " + e.getMessage(), (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

