/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging;

import io.joynr.dispatcher.ServletMessageReceiver;
import io.joynr.messaging.IServletMessageReceivers;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletMessageReceivers
implements IServletMessageReceivers {
    private static final Logger log = LoggerFactory.getLogger(ServletMessageReceivers.class);
    ConcurrentHashMap<String, ServletMessageReceiver> messageReceivers = new ConcurrentHashMap();

    @Nullable
    public ServletMessageReceiver getServletMessageReceiver(String channelId) {
        return (ServletMessageReceiver)this.messageReceivers.get(channelId);
    }

    public void registerServletMessageReceiver(ServletMessageReceiver messageReceiver, String channelId) {
        log.debug("Message Receiver registered for: " + channelId);
        this.messageReceivers.put(channelId, messageReceiver);
    }

    public Collection<ServletMessageReceiver> getAllServletMessageReceivers() {
        return this.messageReceivers.values();
    }

    public boolean contains(String channelId) {
        return this.messageReceivers.containsKey(channelId);
    }
}

