/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.runtime;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.util.Modules;
import com.sun.jersey.guice.JerseyServletModule;
import io.joynr.JoynrApplicationLauncher;
import io.joynr.guice.LowerCaseProperties;
import io.joynr.messaging.IServletMessageReceivers;
import io.joynr.messaging.ServletMessageReceivers;
import io.joynr.messaging.ServletMessagingModule;
import io.joynr.messaging.ServletPropertyLoader;
import io.joynr.runtime.AbstractJoynrInjectorFactory;
import io.joynr.runtime.CCInProcessRuntimeModule;
import io.joynr.runtime.EmptyModule;
import io.joynr.runtime.JoynrApplication;
import io.joynr.runtime.PropertyLoader;
import io.joynr.servlet.JoynrWebServlet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.ArrayUtils;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingServletConfig
extends GuiceServletContextListener {
    public static final String INIT_PARAM_SERVLET_MODULE_CLASSNAME = "servletmodule";
    private static final String IO_JOYNR_APPS_PACKAGES = "io.joynr.apps.packages";
    private static final String DEFAULT_SERVLET_MODULE_NAME = "io.joynr.servlet.ServletModule";
    private static final String DEFAULT_SERVLET_MESSAGING_PROPERTIES = "defaultServletMessaging.properties";
    private String servletModuleName;
    private static final Logger logger = LoggerFactory.getLogger(MessagingServletConfig.class);
    private JerseyServletModule jerseyServletModule;
    private IServletMessageReceivers messageReceivers = new ServletMessageReceivers();
    private JoynrApplicationLauncher appLauncher = null;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        LowerCaseProperties properties = new LowerCaseProperties(PropertyLoader.loadProperties((String)DEFAULT_SERVLET_MESSAGING_PROPERTIES));
        String appPropertiesFileName = servletContext.getInitParameter("properties");
        if (appPropertiesFileName != null) {
            Properties appProperties = ServletPropertyLoader.loadProperties((String)appPropertiesFileName, (ServletContext)servletContext);
            properties.putAll((Map<?, ?>)appProperties);
        } else {
            logger.warn("to load properties, set the initParameter 'properties' ");
        }
        properties.putAll(System.getenv());
        this.servletModuleName = properties.getProperty(INIT_PARAM_SERVLET_MODULE_CLASSNAME);
        this.servletModuleName = this.servletModuleName == null ? DEFAULT_SERVLET_MODULE_NAME : this.servletModuleName;
        String[] appPackages = this.mergeAppPackages((Properties)properties);
        properties.putAll((Map<?, ?>)System.getProperties());
        Reflections reflections = new Reflections(new Object[]{"io.joynr.runtime", appPackages});
        Set classesAnnotatedWithWebServlet = reflections.getTypesAnnotatedWith(JoynrWebServlet.class);
        Set classesAnnotatedWithProvider = reflections.getTypesAnnotatedWith(Provider.class);
        this.jerseyServletModule = new /* Unavailable Anonymous Inner Class!! */;
        Class<?> servletModuleClass = null;
        Module servletModule = null;
        try {
            servletModuleClass = this.getClass().getClassLoader().loadClass(this.servletModuleName);
            servletModule = (Module)servletModuleClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.debug("Servlet module class not found will use default configuration");
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        if (servletModule == null) {
            servletModule = new EmptyModule();
        }
        properties.put("joynr.servlet.context.root", servletContext.getContextPath());
        String hostPath = properties.getProperty("joynr.servlet.hostpath");
        if (hostPath == null) {
            hostPath = properties.getProperty("hostpath");
        }
        if (hostPath != null) {
            properties.setProperty("joynr.servlet.hostpath", hostPath);
        }
        Set joynrApplicationsClasses = reflections.getSubTypesOf(JoynrApplication.class);
        Set joynrInjectorFactoryClasses = reflections.getSubTypesOf(AbstractJoynrInjectorFactory.class);
        assert (joynrInjectorFactoryClasses.size() == 1);
        Injector injector = Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});
        AbstractJoynrInjectorFactory injectorFactory = (AbstractJoynrInjectorFactory)injector.getInstance((Class)joynrInjectorFactoryClasses.iterator().next());
        this.appLauncher = (JoynrApplicationLauncher)injector.getInstance(JoynrApplicationLauncher.class);
        logger.info("starting joynr with properties: {}", (Object)properties);
        this.appLauncher.init((Properties)properties, joynrApplicationsClasses, injectorFactory, new Module[]{Modules.override((Module[])new Module[]{this.jerseyServletModule, new CCInProcessRuntimeModule()}).with(new Module[]{servletModule, new ServletMessagingModule()})});
        super.contextInitialized(servletContextEvent);
    }

    private String[] mergeAppPackages(Properties properties) {
        String systemAppPackagesSetting = System.getProperties().getProperty(IO_JOYNR_APPS_PACKAGES);
        String appPackagesSetting = properties.getProperty(IO_JOYNR_APPS_PACKAGES);
        Object[] appPackages = appPackagesSetting != null ? appPackagesSetting.split(";") : null;
        Object[] systemAppPackages = systemAppPackagesSetting != null ? systemAppPackagesSetting.split(";") : null;
        appPackages = (String[])ArrayUtils.addAll((Object[])appPackages, (Object[])systemAppPackages);
        return appPackages;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (this.appLauncher == null) {
            String msg = "Context cannot be destroyed, as bootstrapUtil has not been initialied correctly";
            logger.error(msg);
            throw new IllegalStateException(MessagingServletConfig.class.getSimpleName() + ":" + msg);
        }
        this.appLauncher.shutdown(true);
        super.contextDestroyed(servletContextEvent);
    }

    protected Injector getInjector() {
        return this.appLauncher.getJoynrInjector();
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ IServletMessageReceivers access$100(MessagingServletConfig x0) {
        return x0.messageReceivers;
    }
}

