/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletPropertyLoader {
    private static final Logger logger = LoggerFactory.getLogger(ServletPropertyLoader.class);

    public static Properties loadProperties(String filename, ServletContext servletContext) {
        Properties properties = new Properties();
        InputStream in = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            in = classLoader.getResourceAsStream(filename);
            if (in == null) {
                logger.error("properties file not found");
            } else {
                properties.load(in);
            }
        }
        catch (IOException e) {
            logger.error("properties file not loaded", (Throwable)e);
        }
        return properties;
    }
}

