/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol.global.jee;

import io.joynr.capabilities.ParticipantIdKeyUtil;
import io.joynr.jeeintegration.api.JoynrLocalDomain;
import io.joynr.jeeintegration.api.JoynrProperties;
import io.joynr.runtime.PropertyLoader;
import java.util.Map;
import java.util.Properties;
import javax.ejb.Singleton;
import javax.enterprise.inject.Produces;
import joynr.infrastructure.GlobalDomainAccessControlListEditorProvider;
import joynr.infrastructure.GlobalDomainAccessControllerProvider;
import joynr.infrastructure.GlobalDomainRoleControllerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JoynrConfigurationProvider {
    private static final Logger logger = LoggerFactory.getLogger(JoynrConfigurationProvider.class);

    @Produces
    @JoynrProperties
    public Properties getJoynrProperties() {
        Properties joynrProperties = new Properties();
        this.readAndSetProperty(joynrProperties, "joynr.messaging.mqtt.brokeruri", "tcp://localhost:1883");
        this.readAndSetProperty(joynrProperties, "joynr.messaging.primaryglobaltransport", "mqtt");
        this.readAndSetProperty(joynrProperties, "joynr.servlet.context.root", "/domain-access-controller-jee/messaging");
        this.readAndSetProperty(joynrProperties, "joynr.servlet.hostpath", "http://localhost:8080");
        this.readAndSetProperty(joynrProperties, "joynr.messaging.channelid", "domainaccesscontroller_channelid");
        this.readAndSetProperty(joynrProperties, "joynr.messaging.discoverydirectoryurl", "tcp://localhost:1883");
        this.readAndSetProperty(joynrProperties, "joynr.messaging.persistence_file", "domain-access-controller-joynr.properties");
        Properties joynrDefaultProperties = PropertyLoader.loadProperties((String)"defaultMessaging.properties");
        if (joynrDefaultProperties.containsKey("joynr.messaging.domainaccesscontrollerparticipantid")) {
            this.readAndSetProperty(joynrProperties, ParticipantIdKeyUtil.getProviderParticipantIdKey((String)this.getJoynrLocalDomain(), GlobalDomainAccessControllerProvider.class), joynrDefaultProperties.getProperty("joynr.messaging.domainaccesscontrollerparticipantid"));
        }
        if (joynrDefaultProperties.containsKey("joynr.messaging.domainaccesscontrollisteditorparticipantid")) {
            this.readAndSetProperty(joynrProperties, ParticipantIdKeyUtil.getProviderParticipantIdKey((String)this.getJoynrLocalDomain(), GlobalDomainAccessControlListEditorProvider.class), joynrDefaultProperties.getProperty("joynr.messaging.domainaccesscontrollisteditorparticipantid"));
        }
        if (joynrDefaultProperties.containsKey("joynr.messaging.domainrolecontrollerparticipantid")) {
            this.readAndSetProperty(joynrProperties, ParticipantIdKeyUtil.getProviderParticipantIdKey((String)this.getJoynrLocalDomain(), GlobalDomainRoleControllerProvider.class), joynrDefaultProperties.getProperty("joynr.messaging.domainrolecontrollerparticipantid"));
        }
        return joynrProperties;
    }

    private void readAndSetProperty(Properties joynrProperties, String propertyKey, String defaultValue) {
        assert (propertyKey != null && !propertyKey.trim().isEmpty()) : "You must specify a non-null, non-empty property key";
        logger.trace("Called with joynrProperties {}, propertyKey {} and defaultValue {}", new Object[]{joynrProperties, propertyKey, defaultValue});
        String value = System.getProperty(propertyKey, defaultValue);
        String envKey = propertyKey.replaceAll("\\.", "_");
        String envValue = null;
        for (Map.Entry<String, String> envEntry : System.getenv().entrySet()) {
            if (!envEntry.getKey().equalsIgnoreCase(envKey)) continue;
            envValue = envEntry.getValue();
            break;
        }
        if (envValue != null && !envValue.trim().isEmpty()) {
            value = envValue;
        }
        logger.debug("Setting property {} to value {}.", (Object)propertyKey, (Object)value);
        joynrProperties.setProperty(propertyKey, value);
    }

    @Produces
    @JoynrLocalDomain
    public String getJoynrLocalDomain() {
        return "io.joynr";
    }
}

