/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol.global.jee;

import com.google.common.collect.Sets;
import io.joynr.accesscontrol.global.jee.CreateOrUpdateResult;
import io.joynr.accesscontrol.global.jee.DomainRoleEntryManager;
import io.joynr.accesscontrol.global.jee.persistence.ControlEntryType;
import io.joynr.accesscontrol.global.jee.persistence.MasterAccessControlEntryEntity;
import io.joynr.exceptions.JoynrIllegalStateException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import joynr.infrastructure.DacTypes.ChangeType;
import joynr.infrastructure.DacTypes.MasterAccessControlEntry;
import joynr.infrastructure.DacTypes.Permission;
import joynr.infrastructure.DacTypes.Role;
import joynr.infrastructure.DacTypes.TrustLevel;

@Stateless
public class MasterAccessControlEntryManager {
    private EntityManager entityManager;
    private DomainRoleEntryManager domainRoleEntryManager;

    protected MasterAccessControlEntryManager() {
    }

    @Inject
    public MasterAccessControlEntryManager(EntityManager entityManager, DomainRoleEntryManager domainRoleEntryManager) {
        this.entityManager = entityManager;
        this.domainRoleEntryManager = domainRoleEntryManager;
    }

    private MasterAccessControlEntry mapEntityToJoynrType(MasterAccessControlEntryEntity entity) {
        MasterAccessControlEntry result = new MasterAccessControlEntry();
        result.setUid(entity.getUserId());
        result.setDomain(entity.getDomain());
        result.setInterfaceName(entity.getInterfaceName());
        result.setDefaultRequiredTrustLevel(entity.getDefaultRequiredTrustLevel());
        result.setPossibleRequiredTrustLevels(entity.getPossibleRequiredTrustLevels().toArray(new TrustLevel[entity.getPossibleRequiredTrustLevels().size()]));
        result.setDefaultRequiredControlEntryChangeTrustLevel(entity.getDefaultRequiredControlEntryChangeTrustLevel());
        result.setPossibleRequiredControlEntryChangeTrustLevels(entity.getPossibleRequiredControlEntryChangeTrustLevels().toArray(new TrustLevel[entity.getPossibleRequiredControlEntryChangeTrustLevels().size()]));
        result.setOperation(entity.getOperation());
        result.setDefaultConsumerPermission(entity.getDefaultConsumerPermission());
        result.setPossibleConsumerPermissions(entity.getPossibleConsumerPermissions().toArray(new Permission[entity.getPossibleConsumerPermissions().size()]));
        return result;
    }

    public MasterAccessControlEntry[] findByUserId(String userId, ControlEntryType type) {
        TypedQuery query = this.entityManager.createQuery("select mace from MasterAccessControlEntryEntity mace where mace.userId = :userId and mace.type = :type", MasterAccessControlEntryEntity.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("type", (Object)type);
        List resultList = query.getResultList();
        Set<MasterAccessControlEntry> resultSet = resultList.stream().map(arg_0 -> this.mapEntityToJoynrType(arg_0)).collect(Collectors.toSet());
        return resultSet.toArray(new MasterAccessControlEntry[resultSet.size()]);
    }

    public MasterAccessControlEntry[] findByUserIdThatAreEditable(String userId, ControlEntryType type) {
        Query query = this.entityManager.createQuery("select mace from MasterAccessControlEntryEntity mace, DomainRoleEntryEntity dre, in(dre.domains) dds where mace.userId = :userId and mace.type = :type and mace.domain = dds and dre.userId = :userId and dre.role = :role");
        query.setParameter("userId", (Object)userId);
        query.setParameter("type", (Object)type);
        query.setParameter("role", (Object)Role.MASTER);
        List resultList = query.getResultList();
        Set<MasterAccessControlEntry> resultSet = resultList.stream().map(arg_0 -> this.mapEntityToJoynrType(arg_0)).collect(Collectors.toSet());
        return resultSet.toArray(new MasterAccessControlEntry[resultSet.size()]);
    }

    public MasterAccessControlEntry[] findByDomainAndInterfaceName(String domain, String interfaceName, ControlEntryType type) {
        TypedQuery query = this.entityManager.createQuery("select mace from MasterAccessControlEntryEntity mace where mace.domain = :domain and mace.interfaceName = :interfaceName and mace.type = :type", MasterAccessControlEntryEntity.class);
        query.setParameter("domain", (Object)domain);
        query.setParameter("interfaceName", (Object)interfaceName);
        query.setParameter("type", (Object)type);
        List resultList = query.getResultList();
        Set<MasterAccessControlEntry> resultSet = resultList.stream().map(arg_0 -> this.mapEntityToJoynrType(arg_0)).collect(Collectors.toSet());
        return resultSet.toArray(new MasterAccessControlEntry[resultSet.size()]);
    }

    private MasterAccessControlEntryEntity findByUserIdDomainInterfaceNameOperationAndType(String userId, String domain, String interfaceName, String operation, ControlEntryType type) {
        TypedQuery query = this.entityManager.createQuery("select mace from MasterAccessControlEntryEntity mace where mace.userId = :userId and mace.domain = :domain and mace.interfaceName = :interfaceName and mace.operation = :operation and mace.type = :type", MasterAccessControlEntryEntity.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("domain", (Object)domain);
        query.setParameter("interfaceName", (Object)interfaceName);
        query.setParameter("operation", (Object)operation);
        query.setParameter("type", (Object)type);
        List resultList = query.getResultList();
        MasterAccessControlEntryEntity entity = null;
        if (resultList.size() == 1) {
            entity = (MasterAccessControlEntryEntity)resultList.get(0);
        } else if (resultList.size() > 1) {
            throw new JoynrIllegalStateException(String.format("Too many master access control entries for unique key uid / domain / interfaceName /operation: %s / %s / %s / %s", userId, domain, interfaceName, operation));
        }
        return entity;
    }

    public CreateOrUpdateResult<MasterAccessControlEntry> createOrUpdate(MasterAccessControlEntry updatedMasterAce, ControlEntryType type) {
        boolean created;
        MasterAccessControlEntryEntity entity = this.findByUserIdDomainInterfaceNameOperationAndType(updatedMasterAce.getUid(), updatedMasterAce.getDomain(), updatedMasterAce.getInterfaceName(), updatedMasterAce.getOperation(), type);
        if (!this.domainRoleEntryManager.hasCurrentUserGotRoleForDomain(Role.MASTER, updatedMasterAce.getDomain())) {
            return null;
        }
        boolean bl = created = entity == null;
        if (created) {
            entity = new MasterAccessControlEntryEntity();
            entity.setUserId(updatedMasterAce.getUid());
            entity.setDomain(updatedMasterAce.getDomain());
            entity.setInterfaceName(updatedMasterAce.getInterfaceName());
            entity.setOperation(updatedMasterAce.getOperation());
            entity.setType(type);
            this.entityManager.persist((Object)entity);
        }
        entity.setDefaultRequiredTrustLevel(updatedMasterAce.getDefaultRequiredTrustLevel());
        entity.setPossibleRequiredTrustLevels((Set)Sets.newHashSet((Object[])updatedMasterAce.getPossibleRequiredTrustLevels()));
        entity.setDefaultRequiredControlEntryChangeTrustLevel(updatedMasterAce.getDefaultRequiredControlEntryChangeTrustLevel());
        entity.setPossibleRequiredControlEntryChangeTrustLevels((Set)Sets.newHashSet((Object[])updatedMasterAce.getPossibleRequiredControlEntryChangeTrustLevels()));
        entity.setDefaultConsumerPermission(updatedMasterAce.getDefaultConsumerPermission());
        entity.setPossibleConsumerPermissions((Set)Sets.newHashSet((Object[])updatedMasterAce.getPossibleConsumerPermissions()));
        return new CreateOrUpdateResult((Object)this.mapEntityToJoynrType(entity), created ? ChangeType.ADD : ChangeType.UPDATE);
    }

    public MasterAccessControlEntry removeByUserIdDomainInterfaceNameAndOperation(String uid, String domain, String interfaceName, String operation, ControlEntryType type) {
        if (!this.domainRoleEntryManager.hasCurrentUserGotRoleForDomain(Role.MASTER, domain)) {
            return null;
        }
        MasterAccessControlEntryEntity entity = this.findByUserIdDomainInterfaceNameOperationAndType(uid, domain, interfaceName, operation, type);
        if (entity != null) {
            this.entityManager.remove((Object)entity);
            return this.mapEntityToJoynrType(entity);
        }
        return null;
    }
}

