/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol.global.jee;

import io.joynr.accesscontrol.global.jee.CreateOrUpdateResult;
import io.joynr.accesscontrol.global.jee.GlobalDomainAccessControllerLocal;
import io.joynr.accesscontrol.global.jee.MasterAccessControlEntryManager;
import io.joynr.accesscontrol.global.jee.MasterRegistrationControlEntryManager;
import io.joynr.accesscontrol.global.jee.OwnerAccessControlEntryManager;
import io.joynr.accesscontrol.global.jee.OwnerRegistrationControlEntryManager;
import io.joynr.accesscontrol.global.jee.persistence.ControlEntryType;
import io.joynr.jeeintegration.api.ServiceProvider;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.transaction.Transactional;
import joynr.infrastructure.DacTypes.ChangeType;
import joynr.infrastructure.DacTypes.MasterAccessControlEntry;
import joynr.infrastructure.DacTypes.MasterRegistrationControlEntry;
import joynr.infrastructure.DacTypes.OwnerAccessControlEntry;
import joynr.infrastructure.DacTypes.OwnerRegistrationControlEntry;
import joynr.infrastructure.GlobalDomainAccessControlListEditorSync;

@Stateless
@ServiceProvider(serviceInterface=GlobalDomainAccessControlListEditorSync.class)
@Transactional
public class GlobalDomainAccessControlListEditorBean
implements GlobalDomainAccessControlListEditorSync {
    private MasterAccessControlEntryManager masterAccessControlEntryManager;
    private OwnerAccessControlEntryManager ownerAccessControlEntryManager;
    private MasterRegistrationControlEntryManager masterRegistrationControlEntryManager;
    private OwnerRegistrationControlEntryManager ownerRegistrationControlEntryManager;
    private GlobalDomainAccessControllerLocal globalDomainAccessControllerBean;

    protected GlobalDomainAccessControlListEditorBean() {
    }

    @Inject
    public GlobalDomainAccessControlListEditorBean(MasterAccessControlEntryManager masterAccessControlEntryManager, OwnerAccessControlEntryManager ownerAccessControlEntryManager, MasterRegistrationControlEntryManager masterRegistrationControlEntryManager, OwnerRegistrationControlEntryManager ownerRegistrationControlEntryManager, GlobalDomainAccessControllerLocal globalDomainAccessControllerBean) {
        this.masterAccessControlEntryManager = masterAccessControlEntryManager;
        this.ownerAccessControlEntryManager = ownerAccessControlEntryManager;
        this.masterRegistrationControlEntryManager = masterRegistrationControlEntryManager;
        this.ownerRegistrationControlEntryManager = ownerRegistrationControlEntryManager;
        this.globalDomainAccessControllerBean = globalDomainAccessControllerBean;
    }

    public MasterAccessControlEntry[] getEditableMasterAccessControlEntries(String uid) {
        return this.masterAccessControlEntryManager.findByUserIdThatAreEditable(uid, ControlEntryType.MASTER);
    }

    public Boolean updateMasterAccessControlEntry(MasterAccessControlEntry updatedMasterAce) {
        CreateOrUpdateResult result = this.masterAccessControlEntryManager.createOrUpdate(updatedMasterAce, ControlEntryType.MASTER);
        if (result != null) {
            MasterAccessControlEntry persistedAce = (MasterAccessControlEntry)result.getEntry();
            this.globalDomainAccessControllerBean.doFireMasterAccessControlEntryChanged(result.getChangeType(), persistedAce);
            return true;
        }
        return false;
    }

    public Boolean removeMasterAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        MasterAccessControlEntry removedEntry = this.masterAccessControlEntryManager.removeByUserIdDomainInterfaceNameAndOperation(uid, domain, interfaceName, operation, ControlEntryType.MASTER);
        if (removedEntry != null) {
            this.globalDomainAccessControllerBean.doFireMasterAccessControlEntryChanged(ChangeType.REMOVE, removedEntry);
            return true;
        }
        return false;
    }

    public MasterAccessControlEntry[] getEditableMediatorAccessControlEntries(String uid) {
        return this.masterAccessControlEntryManager.findByUserIdThatAreEditable(uid, ControlEntryType.MEDIATOR);
    }

    public Boolean updateMediatorAccessControlEntry(MasterAccessControlEntry updatedMediatorAce) {
        CreateOrUpdateResult result = this.masterAccessControlEntryManager.createOrUpdate(updatedMediatorAce, ControlEntryType.MEDIATOR);
        if (result != null) {
            MasterAccessControlEntry persistedEntry = (MasterAccessControlEntry)result.getEntry();
            this.globalDomainAccessControllerBean.doFireMediatorAccessControlEntryChanged(result.getChangeType(), persistedEntry);
            return true;
        }
        return false;
    }

    public Boolean removeMediatorAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        MasterAccessControlEntry removedEntry = this.masterAccessControlEntryManager.removeByUserIdDomainInterfaceNameAndOperation(uid, domain, interfaceName, operation, ControlEntryType.MEDIATOR);
        if (removedEntry != null) {
            this.globalDomainAccessControllerBean.doFireMediatorAccessControlEntryChanged(ChangeType.REMOVE, removedEntry);
            return true;
        }
        return false;
    }

    public OwnerAccessControlEntry[] getEditableOwnerAccessControlEntries(String uid) {
        return this.ownerAccessControlEntryManager.findByUserIdThatAreEditable(uid);
    }

    public Boolean updateOwnerAccessControlEntry(OwnerAccessControlEntry updatedOwnerAce) {
        CreateOrUpdateResult result = this.ownerAccessControlEntryManager.createOrUpdate(updatedOwnerAce);
        if (result != null) {
            OwnerAccessControlEntry entry = (OwnerAccessControlEntry)result.getEntry();
            this.globalDomainAccessControllerBean.doFireOwnerAccessControlEntryChanged(result.getChangeType(), entry);
            return true;
        }
        return false;
    }

    public Boolean removeOwnerAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        OwnerAccessControlEntry removedEntry = this.ownerAccessControlEntryManager.removeByUserIdDomainInterfaceNameAndOperation(uid, domain, interfaceName, operation);
        if (removedEntry != null) {
            this.globalDomainAccessControllerBean.doFireOwnerAccessControlEntryChanged(ChangeType.REMOVE, removedEntry);
            return true;
        }
        return false;
    }

    public MasterRegistrationControlEntry[] getEditableMasterRegistrationControlEntries(String uid) {
        return this.masterRegistrationControlEntryManager.findByUserIdAndThatAreEditable(uid, ControlEntryType.MASTER);
    }

    public Boolean updateMasterRegistrationControlEntry(MasterRegistrationControlEntry updatedMasterRce) {
        CreateOrUpdateResult result = this.masterRegistrationControlEntryManager.createOrUpdate(updatedMasterRce, ControlEntryType.MASTER);
        if (result != null) {
            MasterRegistrationControlEntry entry = (MasterRegistrationControlEntry)result.getEntry();
            this.globalDomainAccessControllerBean.doFireMasterRegistrationControlEntryChanged(result.getChangeType(), entry);
            return true;
        }
        return false;
    }

    public Boolean removeMasterRegistrationControlEntry(String uid, String domain, String interfaceName) {
        MasterRegistrationControlEntry removedEntry = this.masterRegistrationControlEntryManager.removeByUserIdDomainInterfaceNameAndType(uid, domain, interfaceName, ControlEntryType.MASTER);
        if (removedEntry != null) {
            this.globalDomainAccessControllerBean.doFireMasterRegistrationControlEntryChanged(ChangeType.REMOVE, removedEntry);
            return true;
        }
        return false;
    }

    public MasterRegistrationControlEntry[] getEditableMediatorRegistrationControlEntries(String uid) {
        return this.masterRegistrationControlEntryManager.findByUserIdAndThatAreEditable(uid, ControlEntryType.MEDIATOR);
    }

    public Boolean updateMediatorRegistrationControlEntry(MasterRegistrationControlEntry updatedMediatorRce) {
        CreateOrUpdateResult result = this.masterRegistrationControlEntryManager.createOrUpdate(updatedMediatorRce, ControlEntryType.MEDIATOR);
        if (result != null) {
            MasterRegistrationControlEntry entry = (MasterRegistrationControlEntry)result.getEntry();
            this.globalDomainAccessControllerBean.doFireMediatorRegistrationControlEntryChanged(result.getChangeType(), entry);
            return true;
        }
        return false;
    }

    public Boolean removeMediatorRegistrationControlEntry(String uid, String domain, String interfaceName) {
        MasterRegistrationControlEntry removedEntry = this.masterRegistrationControlEntryManager.removeByUserIdDomainInterfaceNameAndType(uid, domain, interfaceName, ControlEntryType.MEDIATOR);
        if (removedEntry != null) {
            this.globalDomainAccessControllerBean.doFireMediatorRegistrationControlEntryChanged(ChangeType.REMOVE, removedEntry);
            return true;
        }
        return false;
    }

    public OwnerRegistrationControlEntry[] getEditableOwnerRegistrationControlEntries(String uid) {
        return this.ownerRegistrationControlEntryManager.findByUserIdAndThatIsEditable(uid);
    }

    public Boolean updateOwnerRegistrationControlEntry(OwnerRegistrationControlEntry updatedOwnerRce) {
        CreateOrUpdateResult result = this.ownerRegistrationControlEntryManager.createOrUpdate(updatedOwnerRce);
        if (result != null) {
            OwnerRegistrationControlEntry entry = (OwnerRegistrationControlEntry)result.getEntry();
            this.globalDomainAccessControllerBean.doFireOwnerRegistrationControlEntryChanged(result.getChangeType(), entry);
            return true;
        }
        return false;
    }

    public Boolean removeOwnerRegistrationControlEntry(String uid, String domain, String interfaceName) {
        OwnerRegistrationControlEntry removedEntry = this.ownerRegistrationControlEntryManager.removeByUserIdDomainAndInterfaceName(uid, domain, interfaceName);
        if (removedEntry != null) {
            this.globalDomainAccessControllerBean.doFireOwnerRegistrationControlEntryChanged(ChangeType.REMOVE, removedEntry);
            return true;
        }
        return false;
    }
}

