/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol.global.jee;

import com.google.common.collect.Sets;
import io.joynr.accesscontrol.global.jee.CreateOrUpdateResult;
import io.joynr.accesscontrol.global.jee.persistence.DomainRoleEntryEntity;
import io.joynr.jeeintegration.api.security.JoynrCallingPrincipal;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.enterprise.context.ContextNotActiveException;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import joynr.infrastructure.DacTypes.ChangeType;
import joynr.infrastructure.DacTypes.DomainRoleEntry;
import joynr.infrastructure.DacTypes.Role;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class DomainRoleEntryManager {
    private static final Logger logger = LoggerFactory.getLogger(DomainRoleEntryManager.class);
    private EntityManager entityManager;
    private JoynrCallingPrincipal joynrCallingPrincipal;

    protected DomainRoleEntryManager() {
    }

    @Inject
    public DomainRoleEntryManager(EntityManager entityManager, JoynrCallingPrincipal joynrCallingPrincipal) {
        this.entityManager = entityManager;
        this.joynrCallingPrincipal = joynrCallingPrincipal;
    }

    private DomainRoleEntry mapEntityToJoynrType(DomainRoleEntryEntity entity) {
        Set entityDomains = entity.getDomains();
        String[] domains = entityDomains.toArray(new String[entityDomains.size()]);
        return new DomainRoleEntry(entity.getUserId(), domains, entity.getRole());
    }

    private DomainRoleEntryEntity mapJoynrTypeToEntity(DomainRoleEntry joynrType) {
        DomainRoleEntryEntity result = new DomainRoleEntryEntity();
        result.setUserId(joynrType.getUid());
        result.setDomains((Set)Sets.newHashSet((Object[])joynrType.getDomains()));
        result.setRole(joynrType.getRole());
        return result;
    }

    public DomainRoleEntry[] findByUserId(String userId) {
        TypedQuery query = this.entityManager.createQuery("select dre from DomainRoleEntryEntity dre where dre.userId = :userId", DomainRoleEntryEntity.class);
        query.setParameter("userId", (Object)userId);
        List entities = query.getResultList();
        Set<DomainRoleEntry> resultSet = entities.stream().map(arg_0 -> this.mapEntityToJoynrType(arg_0)).collect(Collectors.toSet());
        return resultSet.toArray(new DomainRoleEntry[resultSet.size()]);
    }

    private DomainRoleEntryEntity findByUserIdAndRole(String userId, Role role) {
        TypedQuery query = this.entityManager.createQuery("select dre from DomainRoleEntryEntity dre where dre.userId = :userId and dre.role = :role", DomainRoleEntryEntity.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("role", (Object)role);
        List resultList = query.getResultList();
        if (resultList.size() == 1) {
            return (DomainRoleEntryEntity)resultList.get(0);
        }
        if (resultList.size() > 1) {
            throw new IllegalStateException("Too many entries found for DomainRoleEntryEntity with user id " + userId + " and role " + role);
        }
        return null;
    }

    public CreateOrUpdateResult<DomainRoleEntry> createOrUpdate(DomainRoleEntry joynrType) {
        boolean created;
        DomainRoleEntryEntity entity = this.findByUserIdAndRole(joynrType.getUid(), joynrType.getRole());
        boolean bl = created = entity == null;
        if (!created) {
            entity.getDomains().clear();
            entity.getDomains().addAll(Sets.newHashSet((Object[])joynrType.getDomains()));
        } else {
            entity = this.mapJoynrTypeToEntity(joynrType);
            this.entityManager.persist((Object)entity);
        }
        return new CreateOrUpdateResult((Object)this.mapEntityToJoynrType(entity), created ? ChangeType.ADD : ChangeType.UPDATE);
    }

    public DomainRoleEntry removeByUserIdAndRole(String userId, Role role) {
        DomainRoleEntryEntity entity = this.findByUserIdAndRole(userId, role);
        if (entity != null) {
            this.entityManager.remove((Object)entity);
            return this.mapEntityToJoynrType(entity);
        }
        return null;
    }

    public boolean hasCurrentUserGotRoleForDomain(Role role, String domain) {
        try {
            DomainRoleEntryEntity domainRoleEntry = this.findByUserIdAndRole(this.joynrCallingPrincipal.getUsername(), role);
            return domainRoleEntry != null && domainRoleEntry.getDomains().contains(domain);
        }
        catch (ContextNotActiveException e) {
            logger.debug("No joynr message scope context active. Defaulting to 'true'.");
            return true;
        }
    }
}

