/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol.global.jee;

import io.joynr.accesscontrol.global.jee.GlobalDomainAccessControllerLocal;
import io.joynr.accesscontrol.global.jee.MasterAccessControlEntryManager;
import io.joynr.accesscontrol.global.jee.MasterRegistrationControlEntryManager;
import io.joynr.accesscontrol.global.jee.OwnerAccessControlEntryManager;
import io.joynr.accesscontrol.global.jee.OwnerRegistrationControlEntryManager;
import io.joynr.accesscontrol.global.jee.persistence.ControlEntryType;
import io.joynr.jeeintegration.api.ServiceProvider;
import io.joynr.jeeintegration.api.SubscriptionPublisher;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.transaction.Transactional;
import joynr.infrastructure.DacTypes.ChangeType;
import joynr.infrastructure.DacTypes.MasterAccessControlEntry;
import joynr.infrastructure.DacTypes.MasterRegistrationControlEntry;
import joynr.infrastructure.DacTypes.OwnerAccessControlEntry;
import joynr.infrastructure.DacTypes.OwnerRegistrationControlEntry;
import joynr.infrastructure.GlobalDomainAccessControllerSubscriptionPublisher;
import joynr.infrastructure.GlobalDomainAccessControllerSync;

@Stateless
@ServiceProvider(serviceInterface=GlobalDomainAccessControllerSync.class)
@Transactional
public class GlobalDomainAccessControllerBean
implements GlobalDomainAccessControllerLocal {
    private MasterAccessControlEntryManager masterAccessControlEntryManager;
    private OwnerAccessControlEntryManager ownerAccessControlEntryManager;
    private MasterRegistrationControlEntryManager masterRegistrationControlEntryManager;
    private OwnerRegistrationControlEntryManager ownerRegistrationControlEntryManager;
    private GlobalDomainAccessControllerSubscriptionPublisher globalDomainAccessControllerSubscriptionPublisher;

    protected GlobalDomainAccessControllerBean() {
    }

    @Inject
    public GlobalDomainAccessControllerBean(@SubscriptionPublisher GlobalDomainAccessControllerSubscriptionPublisher globalDomainAccessControllerSubscriptionPublisher, MasterAccessControlEntryManager masterAccessControlEntryManager, OwnerAccessControlEntryManager ownerAccessControlEntryManager, MasterRegistrationControlEntryManager masterRegistrationControlEntryManager, OwnerRegistrationControlEntryManager ownerRegistrationControlEntryManager) {
        this.globalDomainAccessControllerSubscriptionPublisher = globalDomainAccessControllerSubscriptionPublisher;
        this.masterAccessControlEntryManager = masterAccessControlEntryManager;
        this.ownerAccessControlEntryManager = ownerAccessControlEntryManager;
        this.masterRegistrationControlEntryManager = masterRegistrationControlEntryManager;
        this.ownerRegistrationControlEntryManager = ownerRegistrationControlEntryManager;
    }

    private String sanitizeForPartition(String value) {
        return value.replaceAll("[^a-zA-Z0-9]", "");
    }

    public MasterAccessControlEntry[] getMasterAccessControlEntries(String uid) {
        return this.masterAccessControlEntryManager.findByUserId(uid, ControlEntryType.MASTER);
    }

    public MasterAccessControlEntry[] getMasterAccessControlEntries(String domain, String interfaceName) {
        return this.masterAccessControlEntryManager.findByDomainAndInterfaceName(domain, interfaceName, ControlEntryType.MASTER);
    }

    public MasterAccessControlEntry[] getMediatorAccessControlEntries(String uid) {
        return this.masterAccessControlEntryManager.findByUserId(uid, ControlEntryType.MEDIATOR);
    }

    public MasterAccessControlEntry[] getMediatorAccessControlEntries(String domain, String interfaceName) {
        return this.masterAccessControlEntryManager.findByDomainAndInterfaceName(domain, interfaceName, ControlEntryType.MEDIATOR);
    }

    public OwnerAccessControlEntry[] getOwnerAccessControlEntries(String uid) {
        return this.ownerAccessControlEntryManager.findByUserId(uid);
    }

    public OwnerAccessControlEntry[] getOwnerAccessControlEntries(String domain, String interfaceName) {
        return this.ownerAccessControlEntryManager.findByDomainAndInterfaceName(domain, interfaceName);
    }

    public MasterRegistrationControlEntry[] getMasterRegistrationControlEntries(String uid) {
        return this.masterRegistrationControlEntryManager.findByUserIdAndType(uid, ControlEntryType.MASTER);
    }

    public MasterRegistrationControlEntry[] getMediatorRegistrationControlEntries(String uid) {
        return this.masterRegistrationControlEntryManager.findByUserIdAndType(uid, ControlEntryType.MEDIATOR);
    }

    public OwnerRegistrationControlEntry[] getOwnerRegistrationControlEntries(String uid) {
        return this.ownerRegistrationControlEntryManager.findByUserId(uid);
    }

    public void doFireMasterAccessControlEntryChanged(ChangeType changeType, MasterAccessControlEntry persistedAce) {
        this.globalDomainAccessControllerSubscriptionPublisher.fireMasterAccessControlEntryChanged(changeType, persistedAce, new String[]{this.sanitizeForPartition(persistedAce.getUid()), this.sanitizeForPartition(persistedAce.getDomain()), this.sanitizeForPartition(persistedAce.getInterfaceName())});
    }

    public void doFireMediatorAccessControlEntryChanged(ChangeType changeType, MasterAccessControlEntry persistedAce) {
        this.globalDomainAccessControllerSubscriptionPublisher.fireMediatorAccessControlEntryChanged(changeType, persistedAce, new String[]{this.sanitizeForPartition(persistedAce.getUid()), this.sanitizeForPartition(persistedAce.getDomain()), this.sanitizeForPartition(persistedAce.getInterfaceName())});
    }

    public void doFireOwnerAccessControlEntryChanged(ChangeType changeType, OwnerAccessControlEntry persistedAce) {
        this.globalDomainAccessControllerSubscriptionPublisher.fireOwnerAccessControlEntryChanged(changeType, persistedAce, new String[]{this.sanitizeForPartition(persistedAce.getUid()), this.sanitizeForPartition(persistedAce.getDomain()), this.sanitizeForPartition(persistedAce.getInterfaceName())});
    }

    public void doFireMasterRegistrationControlEntryChanged(ChangeType changeType, MasterRegistrationControlEntry persistedAce) {
        this.globalDomainAccessControllerSubscriptionPublisher.fireMasterRegistrationControlEntryChanged(changeType, persistedAce, new String[]{this.sanitizeForPartition(persistedAce.getUid()), this.sanitizeForPartition(persistedAce.getDomain()), this.sanitizeForPartition(persistedAce.getInterfaceName())});
    }

    public void doFireMediatorRegistrationControlEntryChanged(ChangeType changeType, MasterRegistrationControlEntry persistedAce) {
        this.globalDomainAccessControllerSubscriptionPublisher.fireMediatorRegistrationControlEntryChanged(changeType, persistedAce, new String[]{this.sanitizeForPartition(persistedAce.getUid()), this.sanitizeForPartition(persistedAce.getDomain()), this.sanitizeForPartition(persistedAce.getInterfaceName())});
    }

    public void doFireOwnerRegistrationControlEntryChanged(ChangeType changeType, OwnerRegistrationControlEntry persistedAce) {
        this.globalDomainAccessControllerSubscriptionPublisher.fireOwnerRegistrationControlEntryChanged(changeType, persistedAce, new String[]{this.sanitizeForPartition(persistedAce.getUid()), this.sanitizeForPartition(persistedAce.getDomain()), this.sanitizeForPartition(persistedAce.getInterfaceName())});
    }
}

