/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol.global.jee;

import io.joynr.accesscontrol.global.jee.CreateOrUpdateResult;
import io.joynr.accesscontrol.global.jee.DomainRoleEntryManager;
import io.joynr.dispatching.subscription.MulticastIdUtil;
import io.joynr.jeeintegration.api.ServiceProvider;
import io.joynr.jeeintegration.api.SubscriptionPublisher;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.transaction.Transactional;
import joynr.infrastructure.DacTypes.ChangeType;
import joynr.infrastructure.DacTypes.DomainRoleEntry;
import joynr.infrastructure.DacTypes.Role;
import joynr.infrastructure.GlobalDomainRoleControllerSubscriptionPublisher;
import joynr.infrastructure.GlobalDomainRoleControllerSync;

@Stateless
@ServiceProvider(serviceInterface=GlobalDomainRoleControllerSync.class)
@Transactional
public class GlobalDomainRoleControllerBean
implements GlobalDomainRoleControllerSync {
    private GlobalDomainRoleControllerSubscriptionPublisher globalDomainRoleControllerSubscriptionPublisher;
    private DomainRoleEntryManager domainRoleEntryManager;

    protected GlobalDomainRoleControllerBean() {
    }

    @Inject
    public GlobalDomainRoleControllerBean(@SubscriptionPublisher GlobalDomainRoleControllerSubscriptionPublisher globalDomainRoleControllerSubscriptionPublisher, DomainRoleEntryManager domainRoleEntryManager) {
        this.globalDomainRoleControllerSubscriptionPublisher = globalDomainRoleControllerSubscriptionPublisher;
        this.domainRoleEntryManager = domainRoleEntryManager;
    }

    public DomainRoleEntry[] getDomainRoles(String uid) {
        return this.domainRoleEntryManager.findByUserId(uid);
    }

    public Boolean updateDomainRole(DomainRoleEntry updatedEntry) {
        CreateOrUpdateResult result = this.domainRoleEntryManager.createOrUpdate(updatedEntry);
        this.globalDomainRoleControllerSubscriptionPublisher.fireDomainRoleEntryChanged(result.getChangeType(), (DomainRoleEntry)result.getEntry(), new String[]{MulticastIdUtil.sanitizeForPartition((String)((DomainRoleEntry)result.getEntry()).getUid())});
        return true;
    }

    public Boolean removeDomainRole(String uid, Role role) {
        DomainRoleEntry removedEntry = this.domainRoleEntryManager.removeByUserIdAndRole(uid, role);
        if (removedEntry != null) {
            this.globalDomainRoleControllerSubscriptionPublisher.fireDomainRoleEntryChanged(ChangeType.REMOVE, removedEntry, new String[]{MulticastIdUtil.sanitizeForPartition((String)uid)});
            return true;
        }
        return false;
    }
}

