/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol.global.jee;

import com.google.common.collect.Sets;
import io.joynr.accesscontrol.global.jee.CreateOrUpdateResult;
import io.joynr.accesscontrol.global.jee.DomainRoleEntryManager;
import io.joynr.accesscontrol.global.jee.persistence.ControlEntryType;
import io.joynr.accesscontrol.global.jee.persistence.MasterRegistrationControlEntryEntity;
import io.joynr.exceptions.JoynrIllegalStateException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import joynr.infrastructure.DacTypes.ChangeType;
import joynr.infrastructure.DacTypes.MasterRegistrationControlEntry;
import joynr.infrastructure.DacTypes.Permission;
import joynr.infrastructure.DacTypes.Role;
import joynr.infrastructure.DacTypes.TrustLevel;

@Stateless
public class MasterRegistrationControlEntryManager {
    private EntityManager entityManager;
    private DomainRoleEntryManager domainRoleEntryManager;

    protected MasterRegistrationControlEntryManager() {
    }

    @Inject
    public MasterRegistrationControlEntryManager(EntityManager entityManager, DomainRoleEntryManager domainRoleEntryManager) {
        this.entityManager = entityManager;
        this.domainRoleEntryManager = domainRoleEntryManager;
    }

    private MasterRegistrationControlEntry[] executeAndConvert(Query query) {
        List resultList = query.getResultList();
        Set<MasterRegistrationControlEntry> resultSet = resultList.stream().map(arg_0 -> this.mapEntityToJoynrType(arg_0)).collect(Collectors.toSet());
        return resultSet.toArray(new MasterRegistrationControlEntry[resultSet.size()]);
    }

    private MasterRegistrationControlEntry mapEntityToJoynrType(MasterRegistrationControlEntryEntity entity) {
        HashSet possibleRequiredTrustLevels = Sets.newHashSet((Iterable)entity.getPossibleRequiredTrustLevels());
        HashSet possibleRequiredControlEntryChangeTrustLevels = Sets.newHashSet((Iterable)entity.getPossibleRequiredControlEntryChangeTrustLevels());
        HashSet possibleProviderPermissions = Sets.newHashSet((Object[])new Permission[]{entity.getDefaultProviderPermission()});
        MasterRegistrationControlEntry entry = new MasterRegistrationControlEntry(entity.getUserId(), entity.getDomain(), entity.getInterfaceName(), entity.getDefaultRequiredTrustLevel(), possibleRequiredTrustLevels.toArray(new TrustLevel[possibleRequiredTrustLevels.size()]), entity.getDefaultRequiredControlEntryChangeTrustLevel(), possibleRequiredControlEntryChangeTrustLevels.toArray(new TrustLevel[possibleRequiredControlEntryChangeTrustLevels.size()]), entity.getDefaultProviderPermission(), possibleProviderPermissions.toArray(new Permission[possibleProviderPermissions.size()]));
        return entry;
    }

    public MasterRegistrationControlEntry[] findByUserIdAndType(String userId, ControlEntryType type) {
        TypedQuery query = this.entityManager.createQuery("select mrce from MasterRegistrationControlEntryEntity mrce where mrce.userId = :userId and mrce.type = :type", MasterRegistrationControlEntryEntity.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("type", (Object)type);
        return this.executeAndConvert((Query)query);
    }

    public MasterRegistrationControlEntry[] findByUserIdAndThatAreEditable(String userId, ControlEntryType type) {
        Query query = this.entityManager.createQuery("select mrce from MasterRegistrationControlEntryEntity mrce, DomainRoleEntryEntity dre, in(dre.domains) dds where mrce.userId = :userId and mrce.type = :type and mrce.domain = dds and dre.userId = :userId and dre.role = :role");
        query.setParameter("userId", (Object)userId);
        query.setParameter("type", (Object)type);
        query.setParameter("role", (Object)Role.MASTER);
        return this.executeAndConvert(query);
    }

    private MasterRegistrationControlEntryEntity findByUserIdDomainInterfaceNameOperationAndType(String userId, String domain, String interfaceName, ControlEntryType type) {
        TypedQuery query = this.entityManager.createQuery("select mrce from MasterRegistrationControlEntryEntity mrce where mrce.userId = :userId and mrce.domain = :domain and mrce.interfaceName = :interfaceName and mrce.type = :type", MasterRegistrationControlEntryEntity.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("domain", (Object)domain);
        query.setParameter("interfaceName", (Object)interfaceName);
        query.setParameter("type", (Object)type);
        List resultList = query.getResultList();
        MasterRegistrationControlEntryEntity entity = null;
        if (resultList.size() == 1) {
            entity = (MasterRegistrationControlEntryEntity)resultList.get(0);
        } else if (resultList.size() > 1) {
            throw new JoynrIllegalStateException(String.format("Too many results found for %s with userId / domain / interfaceName / type: %s / %s / %s / %s", MasterRegistrationControlEntryEntity.class.getSimpleName(), userId, domain, interfaceName, type));
        }
        return entity;
    }

    public CreateOrUpdateResult<MasterRegistrationControlEntry> createOrUpdate(MasterRegistrationControlEntry updatedMasterRce, ControlEntryType type) {
        boolean created;
        if (!this.domainRoleEntryManager.hasCurrentUserGotRoleForDomain(Role.MASTER, updatedMasterRce.getDomain())) {
            return null;
        }
        MasterRegistrationControlEntryEntity entity = this.findByUserIdDomainInterfaceNameOperationAndType(updatedMasterRce.getUid(), updatedMasterRce.getDomain(), updatedMasterRce.getInterfaceName(), type);
        boolean bl = created = entity == null;
        if (created) {
            entity = new MasterRegistrationControlEntryEntity();
            entity.setUserId(updatedMasterRce.getUid());
            entity.setDomain(updatedMasterRce.getDomain());
            entity.setInterfaceName(updatedMasterRce.getInterfaceName());
            entity.setType(type);
            this.entityManager.persist((Object)entity);
        }
        entity.setDefaultRequiredTrustLevel(updatedMasterRce.getDefaultRequiredTrustLevel());
        entity.setPossibleRequiredTrustLevels((Set)Sets.newHashSet((Object[])updatedMasterRce.getPossibleRequiredTrustLevels()));
        entity.setDefaultRequiredControlEntryChangeTrustLevel(updatedMasterRce.getDefaultRequiredControlEntryChangeTrustLevel());
        entity.setPossibleRequiredControlEntryChangeTrustLevels((Set)Sets.newHashSet((Object[])updatedMasterRce.getPossibleRequiredControlEntryChangeTrustLevels()));
        entity.setDefaultProviderPermission(updatedMasterRce.getDefaultProviderPermission());
        entity.setPossibleProviderPermissions((Set)Sets.newHashSet((Object[])updatedMasterRce.getPossibleProviderPermissions()));
        return new CreateOrUpdateResult((Object)this.mapEntityToJoynrType(entity), created ? ChangeType.ADD : ChangeType.UPDATE);
    }

    public MasterRegistrationControlEntry removeByUserIdDomainInterfaceNameAndType(String userId, String domain, String interfaceName, ControlEntryType type) {
        if (!this.domainRoleEntryManager.hasCurrentUserGotRoleForDomain(Role.MASTER, domain)) {
            return null;
        }
        MasterRegistrationControlEntryEntity entity = this.findByUserIdDomainInterfaceNameOperationAndType(userId, domain, interfaceName, type);
        if (entity != null) {
            this.entityManager.remove((Object)entity);
            return this.mapEntityToJoynrType(entity);
        }
        return null;
    }
}

