/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol.global.jee;

import io.joynr.accesscontrol.global.jee.CreateOrUpdateResult;
import io.joynr.accesscontrol.global.jee.DomainRoleEntryManager;
import io.joynr.accesscontrol.global.jee.persistence.OwnerAccessControlEntryEntity;
import io.joynr.exceptions.JoynrIllegalStateException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import joynr.infrastructure.DacTypes.ChangeType;
import joynr.infrastructure.DacTypes.OwnerAccessControlEntry;
import joynr.infrastructure.DacTypes.Role;

@Stateless
public class OwnerAccessControlEntryManager {
    private EntityManager entityManager;
    private DomainRoleEntryManager domainRoleEntryManager;

    protected OwnerAccessControlEntryManager() {
    }

    @Inject
    public OwnerAccessControlEntryManager(EntityManager entityManager, DomainRoleEntryManager domainRoleEntryManager) {
        this.entityManager = entityManager;
        this.domainRoleEntryManager = domainRoleEntryManager;
    }

    private OwnerAccessControlEntry mapEntityToJoynrType(OwnerAccessControlEntryEntity entity) {
        OwnerAccessControlEntry result = new OwnerAccessControlEntry(entity.getUserId(), entity.getDomain(), entity.getInterfaceName(), entity.getRequiredTrustLevel(), entity.getRequiredAceChangeTrustLevel(), entity.getOperation(), entity.getConsumerPermission());
        return result;
    }

    private OwnerAccessControlEntry[] executeAndConvert(Query query) {
        List resultList = query.getResultList();
        Set<OwnerAccessControlEntry> resultSet = resultList.stream().map(arg_0 -> this.mapEntityToJoynrType(arg_0)).collect(Collectors.toSet());
        return resultSet.toArray(new OwnerAccessControlEntry[resultSet.size()]);
    }

    public OwnerAccessControlEntry[] findByUserId(String userId) {
        TypedQuery query = this.entityManager.createQuery("select oace from OwnerAccessControlEntryEntity oace where oace.userId = :userId", OwnerAccessControlEntryEntity.class);
        query.setParameter("userId", (Object)userId);
        return this.executeAndConvert((Query)query);
    }

    public OwnerAccessControlEntry[] findByDomainAndInterfaceName(String domain, String interfaceName) {
        TypedQuery query = this.entityManager.createQuery("select oace from OwnerAccessControlEntryEntity oace where oace.domain = :domain and oace.interfaceName = :interfaceName", OwnerAccessControlEntryEntity.class);
        query.setParameter("domain", (Object)domain);
        query.setParameter("interfaceName", (Object)interfaceName);
        return this.executeAndConvert((Query)query);
    }

    public OwnerAccessControlEntry[] findByUserIdThatAreEditable(String userId) {
        Query query = this.entityManager.createQuery("select oace from OwnerAccessControlEntryEntity oace, DomainRoleEntryEntity dre, in(dre.domains) dds where oace.userId = :userId and oace.domain = dds and dre.userId = :userId and dre.role = :role");
        query.setParameter("userId", (Object)userId);
        query.setParameter("role", (Object)Role.OWNER);
        return this.executeAndConvert(query);
    }

    public CreateOrUpdateResult<OwnerAccessControlEntry> createOrUpdate(OwnerAccessControlEntry updatedOwnerAce) {
        boolean created;
        if (!this.domainRoleEntryManager.hasCurrentUserGotRoleForDomain(Role.OWNER, updatedOwnerAce.getDomain())) {
            return null;
        }
        OwnerAccessControlEntryEntity entity = this.findByUserIdDomainInterfaceNameAndOperation(updatedOwnerAce.getUid(), updatedOwnerAce.getDomain(), updatedOwnerAce.getInterfaceName(), updatedOwnerAce.getOperation());
        boolean bl = created = entity == null;
        if (created) {
            entity = new OwnerAccessControlEntryEntity();
            entity.setUserId(updatedOwnerAce.getUid());
            entity.setDomain(updatedOwnerAce.getDomain());
            entity.setInterfaceName(updatedOwnerAce.getInterfaceName());
            entity.setOperation(updatedOwnerAce.getOperation());
            this.entityManager.persist((Object)entity);
        }
        entity.setRequiredTrustLevel(updatedOwnerAce.getRequiredTrustLevel());
        entity.setRequiredAceChangeTrustLevel(updatedOwnerAce.getRequiredAceChangeTrustLevel());
        entity.setConsumerPermission(updatedOwnerAce.getConsumerPermission());
        return new CreateOrUpdateResult((Object)this.mapEntityToJoynrType(entity), created ? ChangeType.ADD : ChangeType.UPDATE);
    }

    private OwnerAccessControlEntryEntity findByUserIdDomainInterfaceNameAndOperation(String userId, String domain, String interfaceName, String operation) {
        OwnerAccessControlEntryEntity entity = null;
        TypedQuery query = this.entityManager.createQuery("select oace from OwnerAccessControlEntryEntity oace where oace.userId = :userId and oace.domain = :domain and oace.interfaceName = :interfaceName and oace.operation = :operation", OwnerAccessControlEntryEntity.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("domain", (Object)domain);
        query.setParameter("interfaceName", (Object)interfaceName);
        query.setParameter("operation", (Object)operation);
        List resultList = query.getResultList();
        if (resultList.size() == 1) {
            entity = (OwnerAccessControlEntryEntity)resultList.get(0);
        } else if (resultList.size() > 1) {
            throw new JoynrIllegalStateException(String.format("Too many results found for %s for userId / domain / interfaceName / operation: %s / %s / %s / %s", OwnerAccessControlEntryEntity.class.getSimpleName(), userId, domain, interfaceName, operation));
        }
        return entity;
    }

    public OwnerAccessControlEntry removeByUserIdDomainInterfaceNameAndOperation(String userId, String domain, String interfaceName, String operation) {
        if (!this.domainRoleEntryManager.hasCurrentUserGotRoleForDomain(Role.MASTER, domain)) {
            return null;
        }
        OwnerAccessControlEntryEntity entity = this.findByUserIdDomainInterfaceNameAndOperation(userId, domain, interfaceName, operation);
        OwnerAccessControlEntry removedEntry = null;
        if (entity != null) {
            this.entityManager.remove((Object)entity);
            removedEntry = this.mapEntityToJoynrType(entity);
        }
        return removedEntry;
    }
}

