/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol.global.jee;

import io.joynr.accesscontrol.global.jee.CreateOrUpdateResult;
import io.joynr.accesscontrol.global.jee.DomainRoleEntryManager;
import io.joynr.accesscontrol.global.jee.persistence.OwnerRegistrationControlEntryEntity;
import io.joynr.exceptions.JoynrIllegalStateException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import joynr.infrastructure.DacTypes.ChangeType;
import joynr.infrastructure.DacTypes.OwnerRegistrationControlEntry;
import joynr.infrastructure.DacTypes.Role;

@Stateless
public class OwnerRegistrationControlEntryManager {
    private EntityManager entityManager;
    private DomainRoleEntryManager domainRoleEntryManager;

    protected OwnerRegistrationControlEntryManager() {
    }

    @Inject
    public OwnerRegistrationControlEntryManager(EntityManager entityManager, DomainRoleEntryManager domainRoleEntryManager) {
        this.entityManager = entityManager;
        this.domainRoleEntryManager = domainRoleEntryManager;
    }

    private OwnerRegistrationControlEntry[] executeAndCovert(Query query) {
        List resultList = query.getResultList();
        Set<OwnerRegistrationControlEntry> resultSet = resultList.stream().map(arg_0 -> this.mapEntityToJoynrType(arg_0)).collect(Collectors.toSet());
        return resultSet.toArray(new OwnerRegistrationControlEntry[resultSet.size()]);
    }

    private OwnerRegistrationControlEntry mapEntityToJoynrType(OwnerRegistrationControlEntryEntity entity) {
        return new OwnerRegistrationControlEntry(entity.getUserId(), entity.getDomain(), entity.getInterfaceName(), entity.getRequiredTrustLevel(), entity.getRequiredAceChangeTrustLevel(), entity.getProviderPermission());
    }

    public OwnerRegistrationControlEntry[] findByUserId(String userId) {
        TypedQuery query = this.entityManager.createQuery("select orce from OwnerRegistrationControlEntryEntity orce where orce.userId = :userId", OwnerRegistrationControlEntryEntity.class);
        query.setParameter("userId", (Object)userId);
        return this.executeAndCovert((Query)query);
    }

    public OwnerRegistrationControlEntry[] findByUserIdAndThatIsEditable(String userId) {
        TypedQuery query = this.entityManager.createQuery("select orce from OwnerRegistrationControlEntryEntity orce, DomainRoleEntryEntity dre, in(dre.domains) dds where orce.userId = :userId and dre.userId = :userId and dre.role = :role and orce.domain = dds", OwnerRegistrationControlEntryEntity.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("role", (Object)Role.OWNER);
        return this.executeAndCovert((Query)query);
    }

    private OwnerRegistrationControlEntryEntity findByUserIdDomainAndInterfaceName(String userId, String domain, String interfaceName) {
        TypedQuery query = this.entityManager.createQuery("select orce from OwnerRegistrationControlEntryEntity orce where orce.userId = :userId and orce.domain = :domain and orce.interfaceName = :interfaceName", OwnerRegistrationControlEntryEntity.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("domain", (Object)domain);
        query.setParameter("interfaceName", (Object)interfaceName);
        List resultList = query.getResultList();
        OwnerRegistrationControlEntryEntity entity = null;
        if (resultList.size() == 1) {
            entity = (OwnerRegistrationControlEntryEntity)resultList.get(0);
        } else if (resultList.size() > 1) {
            throw new JoynrIllegalStateException(String.format("Too many results found for %s for userId / domain / interfaceName / operation: %s / %s / %s", OwnerRegistrationControlEntryEntity.class.getSimpleName(), userId, domain, interfaceName));
        }
        return entity;
    }

    public CreateOrUpdateResult<OwnerRegistrationControlEntry> createOrUpdate(OwnerRegistrationControlEntry updatedOwnerRce) {
        boolean created;
        if (!this.domainRoleEntryManager.hasCurrentUserGotRoleForDomain(Role.OWNER, updatedOwnerRce.getDomain())) {
            return null;
        }
        OwnerRegistrationControlEntryEntity entity = this.findByUserIdDomainAndInterfaceName(updatedOwnerRce.getUid(), updatedOwnerRce.getDomain(), updatedOwnerRce.getInterfaceName());
        boolean bl = created = entity == null;
        if (created) {
            entity = new OwnerRegistrationControlEntryEntity();
            entity.setUserId(updatedOwnerRce.getUid());
            entity.setDomain(updatedOwnerRce.getDomain());
            entity.setInterfaceName(updatedOwnerRce.getInterfaceName());
            this.entityManager.persist((Object)entity);
        }
        entity.setRequiredTrustLevel(updatedOwnerRce.getRequiredTrustLevel());
        entity.setRequiredAceChangeTrustLevel(updatedOwnerRce.getRequiredAceChangeTrustLevel());
        entity.setProviderPermission(updatedOwnerRce.getProviderPermission());
        return new CreateOrUpdateResult((Object)this.mapEntityToJoynrType(entity), created ? ChangeType.ADD : ChangeType.UPDATE);
    }

    public OwnerRegistrationControlEntry removeByUserIdDomainAndInterfaceName(String userId, String domain, String interfaceName) {
        if (!this.domainRoleEntryManager.hasCurrentUserGotRoleForDomain(Role.OWNER, domain)) {
            return null;
        }
        OwnerRegistrationControlEntryEntity entity = this.findByUserIdDomainAndInterfaceName(userId, domain, interfaceName);
        if (entity != null) {
            this.entityManager.remove((Object)entity);
            return this.mapEntityToJoynrType(entity);
        }
        return null;
    }
}

