/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol.global;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.joynr.accesscontrol.DomainAccessControlStore;
import io.joynr.accesscontrol.global.GlobalDomainAccessControllerProviderImpl;
import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.Promise;
import java.util.Arrays;
import joynr.infrastructure.DacTypes.ChangeType;
import joynr.infrastructure.DacTypes.DomainRoleEntry;
import joynr.infrastructure.DacTypes.MasterAccessControlEntry;
import joynr.infrastructure.DacTypes.MasterRegistrationControlEntry;
import joynr.infrastructure.DacTypes.OwnerAccessControlEntry;
import joynr.infrastructure.DacTypes.OwnerRegistrationControlEntry;
import joynr.infrastructure.DacTypes.Role;
import joynr.infrastructure.GlobalDomainAccessControlListEditorAbstractProvider;
import joynr.infrastructure.GlobalDomainAccessControlListEditorProvider;

@Singleton
public class GlobalDomainAccessControlListEditorProviderImpl
extends GlobalDomainAccessControlListEditorAbstractProvider {
    private static final String DUMMY_USERID = "dummyUserId";
    private final DomainAccessControlStore domainAccessStore;
    private GlobalDomainAccessControllerProviderImpl domainAccessControllerProvider;

    @Inject
    public GlobalDomainAccessControlListEditorProviderImpl(DomainAccessControlStore domainAccessStore, GlobalDomainAccessControllerProviderImpl domainAccessControllerProvider) {
        this.domainAccessStore = domainAccessStore;
        this.domainAccessControllerProvider = domainAccessControllerProvider;
    }

    public Promise<GlobalDomainAccessControlListEditorProvider.GetEditableMasterAccessControlEntriesDeferred> getEditableMasterAccessControlEntries(String uid) {
        GlobalDomainAccessControlListEditorProvider.GetEditableMasterAccessControlEntriesDeferred deferred = new GlobalDomainAccessControlListEditorProvider.GetEditableMasterAccessControlEntriesDeferred();
        deferred.resolve(this.domainAccessStore.getEditableMasterAccessControlEntries(uid).toArray(new MasterAccessControlEntry[0]));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalDomainAccessControlListEditorProvider.UpdateMasterAccessControlEntryDeferred> updateMasterAccessControlEntry(MasterAccessControlEntry updatedMasterAccessControlEntry) {
        GlobalDomainAccessControlListEditorProvider.UpdateMasterAccessControlEntryDeferred deferred = new GlobalDomainAccessControlListEditorProvider.UpdateMasterAccessControlEntryDeferred();
        if (!this.hasRoleMaster(DUMMY_USERID, updatedMasterAccessControlEntry.getDomain())) {
            deferred.resolve(Boolean.valueOf(false));
        } else {
            boolean updateSuccess = this.domainAccessStore.updateMasterAccessControlEntry(updatedMasterAccessControlEntry);
            if (updateSuccess) {
                this.domainAccessControllerProvider.fireMasterAccessControlEntryChanged(ChangeType.UPDATE, updatedMasterAccessControlEntry, new String[0]);
            }
            deferred.resolve(Boolean.valueOf(updateSuccess));
        }
        return new Promise((AbstractDeferred)deferred);
    }

    private boolean hasRoleMaster(String userId, String domain) {
        DomainRoleEntry domainRole = this.domainAccessStore.getDomainRole(userId, Role.MASTER);
        return domainRole != null && Arrays.asList(domainRole.getDomains()).contains(domain);
    }

    public Promise<GlobalDomainAccessControlListEditorProvider.RemoveMasterAccessControlEntryDeferred> removeMasterAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        GlobalDomainAccessControlListEditorProvider.RemoveMasterAccessControlEntryDeferred deferred = new GlobalDomainAccessControlListEditorProvider.RemoveMasterAccessControlEntryDeferred();
        boolean removeSuccess = this.domainAccessStore.removeMasterAccessControlEntry(uid, domain, interfaceName, operation);
        if (removeSuccess) {
            MasterAccessControlEntry removedEntry = new MasterAccessControlEntry(uid, domain, interfaceName, null, null, null, null, operation, null, null);
            this.domainAccessControllerProvider.fireMasterAccessControlEntryChanged(ChangeType.REMOVE, removedEntry, new String[0]);
        }
        deferred.resolve(Boolean.valueOf(removeSuccess));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalDomainAccessControlListEditorProvider.GetEditableMediatorAccessControlEntriesDeferred> getEditableMediatorAccessControlEntries(String uid) {
        GlobalDomainAccessControlListEditorProvider.GetEditableMediatorAccessControlEntriesDeferred deferred = new GlobalDomainAccessControlListEditorProvider.GetEditableMediatorAccessControlEntriesDeferred();
        deferred.resolve(this.domainAccessStore.getEditableMediatorAccessControlEntries(uid).toArray(new MasterAccessControlEntry[0]));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalDomainAccessControlListEditorProvider.UpdateMediatorAccessControlEntryDeferred> updateMediatorAccessControlEntry(MasterAccessControlEntry updatedMediatorAccessControlEntry) {
        GlobalDomainAccessControlListEditorProvider.UpdateMediatorAccessControlEntryDeferred deferred = new GlobalDomainAccessControlListEditorProvider.UpdateMediatorAccessControlEntryDeferred();
        if (!this.hasRoleMaster(DUMMY_USERID, updatedMediatorAccessControlEntry.getDomain())) {
            deferred.resolve(Boolean.valueOf(false));
        } else {
            boolean updateSuccess = this.domainAccessStore.updateMediatorAccessControlEntry(updatedMediatorAccessControlEntry);
            if (updateSuccess) {
                this.domainAccessControllerProvider.fireMediatorAccessControlEntryChanged(ChangeType.UPDATE, updatedMediatorAccessControlEntry, new String[0]);
            }
            deferred.resolve(Boolean.valueOf(updateSuccess));
        }
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalDomainAccessControlListEditorProvider.RemoveMediatorAccessControlEntryDeferred> removeMediatorAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        GlobalDomainAccessControlListEditorProvider.RemoveMediatorAccessControlEntryDeferred deferred = new GlobalDomainAccessControlListEditorProvider.RemoveMediatorAccessControlEntryDeferred();
        boolean removeSuccess = this.domainAccessStore.removeMediatorAccessControlEntry(uid, domain, interfaceName, operation);
        if (removeSuccess) {
            MasterAccessControlEntry removedEntry = new MasterAccessControlEntry(uid, domain, interfaceName, null, null, null, null, operation, null, null);
            this.domainAccessControllerProvider.fireMediatorAccessControlEntryChanged(ChangeType.REMOVE, removedEntry, new String[0]);
        }
        deferred.resolve(Boolean.valueOf(removeSuccess));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalDomainAccessControlListEditorProvider.GetEditableOwnerAccessControlEntriesDeferred> getEditableOwnerAccessControlEntries(String uid) {
        GlobalDomainAccessControlListEditorProvider.GetEditableOwnerAccessControlEntriesDeferred deferred = new GlobalDomainAccessControlListEditorProvider.GetEditableOwnerAccessControlEntriesDeferred();
        deferred.resolve(this.domainAccessStore.getEditableOwnerAccessControlEntries(uid).toArray(new OwnerAccessControlEntry[0]));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalDomainAccessControlListEditorProvider.UpdateOwnerAccessControlEntryDeferred> updateOwnerAccessControlEntry(OwnerAccessControlEntry updatedOwnerAccessControlEntry) {
        GlobalDomainAccessControlListEditorProvider.UpdateOwnerAccessControlEntryDeferred deferred = new GlobalDomainAccessControlListEditorProvider.UpdateOwnerAccessControlEntryDeferred();
        if (!this.hasRoleMaster(DUMMY_USERID, updatedOwnerAccessControlEntry.getDomain())) {
            deferred.resolve(Boolean.valueOf(false));
        } else {
            boolean updateSuccess = this.domainAccessStore.updateOwnerAccessControlEntry(updatedOwnerAccessControlEntry);
            if (updateSuccess) {
                this.domainAccessControllerProvider.fireOwnerAccessControlEntryChanged(ChangeType.UPDATE, updatedOwnerAccessControlEntry, new String[0]);
            }
            deferred.resolve(Boolean.valueOf(updateSuccess));
        }
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalDomainAccessControlListEditorProvider.RemoveOwnerAccessControlEntryDeferred> removeOwnerAccessControlEntry(String uid, String domain, String interfaceName, String operation) {
        GlobalDomainAccessControlListEditorProvider.RemoveOwnerAccessControlEntryDeferred deferred = new GlobalDomainAccessControlListEditorProvider.RemoveOwnerAccessControlEntryDeferred();
        boolean removeSuccess = this.domainAccessStore.removeOwnerAccessControlEntry(uid, domain, interfaceName, operation);
        if (removeSuccess) {
            OwnerAccessControlEntry removedEntry = new OwnerAccessControlEntry(uid, domain, interfaceName, null, null, operation, null);
            this.domainAccessControllerProvider.fireOwnerAccessControlEntryChanged(ChangeType.REMOVE, removedEntry, new String[0]);
        }
        deferred.resolve(Boolean.valueOf(removeSuccess));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalDomainAccessControlListEditorProvider.GetEditableMasterRegistrationControlEntriesDeferred> getEditableMasterRegistrationControlEntries(String uid) {
        assert (false) : "method not implemented";
        return null;
    }

    public Promise<GlobalDomainAccessControlListEditorProvider.UpdateMasterRegistrationControlEntryDeferred> updateMasterRegistrationControlEntry(MasterRegistrationControlEntry updatedMasterRce) {
        assert (false) : "method not implemented";
        return null;
    }

    public Promise<GlobalDomainAccessControlListEditorProvider.RemoveMasterRegistrationControlEntryDeferred> removeMasterRegistrationControlEntry(String uid, String domain, String interfaceName) {
        assert (false) : "method not implemented";
        return null;
    }

    public Promise<GlobalDomainAccessControlListEditorProvider.GetEditableMediatorRegistrationControlEntriesDeferred> getEditableMediatorRegistrationControlEntries(String uid) {
        assert (false) : "method not implemented";
        return null;
    }

    public Promise<GlobalDomainAccessControlListEditorProvider.UpdateMediatorRegistrationControlEntryDeferred> updateMediatorRegistrationControlEntry(MasterRegistrationControlEntry updatedMediatorRce) {
        assert (false) : "method not implemented";
        return null;
    }

    public Promise<GlobalDomainAccessControlListEditorProvider.RemoveMediatorRegistrationControlEntryDeferred> removeMediatorRegistrationControlEntry(String uid, String domain, String interfaceName) {
        assert (false) : "method not implemented";
        return null;
    }

    public Promise<GlobalDomainAccessControlListEditorProvider.GetEditableOwnerRegistrationControlEntriesDeferred> getEditableOwnerRegistrationControlEntries(String uid) {
        assert (false) : "method not implemented";
        return null;
    }

    public Promise<GlobalDomainAccessControlListEditorProvider.UpdateOwnerRegistrationControlEntryDeferred> updateOwnerRegistrationControlEntry(OwnerRegistrationControlEntry updatedOwnerRce) {
        assert (false) : "method not implemented";
        return null;
    }

    public Promise<GlobalDomainAccessControlListEditorProvider.RemoveOwnerRegistrationControlEntryDeferred> removeOwnerRegistrationControlEntry(String uid, String domain, String interfaceName) {
        assert (false) : "method not implemented";
        return null;
    }
}

