/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol.global;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.joynr.accesscontrol.DomainAccessControlStore;
import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.Promise;
import joynr.infrastructure.DacTypes.MasterAccessControlEntry;
import joynr.infrastructure.DacTypes.OwnerAccessControlEntry;
import joynr.infrastructure.GlobalDomainAccessControllerAbstractProvider;
import joynr.infrastructure.GlobalDomainAccessControllerProvider;

@Singleton
public class GlobalDomainAccessControllerProviderImpl
extends GlobalDomainAccessControllerAbstractProvider {
    private static final String DUMMY_USERID = "dummyUserId";
    private final DomainAccessControlStore domainAccessStore;

    @Inject
    public GlobalDomainAccessControllerProviderImpl(DomainAccessControlStore domainAccessStore) {
        this.domainAccessStore = domainAccessStore;
    }

    public Promise<GlobalDomainAccessControllerProvider.GetMasterAccessControlEntries1Deferred> getMasterAccessControlEntries(String uid) {
        GlobalDomainAccessControllerProvider.GetMasterAccessControlEntries1Deferred deferred = new GlobalDomainAccessControllerProvider.GetMasterAccessControlEntries1Deferred();
        deferred.resolve(this.domainAccessStore.getMasterAccessControlEntries(uid).toArray(new MasterAccessControlEntry[0]));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalDomainAccessControllerProvider.GetMasterAccessControlEntries1Deferred> getMasterAccessControlEntries(String domain, String interfaceName) {
        GlobalDomainAccessControllerProvider.GetMasterAccessControlEntries1Deferred deferred = new GlobalDomainAccessControllerProvider.GetMasterAccessControlEntries1Deferred();
        deferred.resolve(this.domainAccessStore.getMasterAccessControlEntries(domain, interfaceName).toArray(new MasterAccessControlEntry[0]));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalDomainAccessControllerProvider.GetMediatorAccessControlEntries1Deferred> getMediatorAccessControlEntries(String uid) {
        GlobalDomainAccessControllerProvider.GetMediatorAccessControlEntries1Deferred deferred = new GlobalDomainAccessControllerProvider.GetMediatorAccessControlEntries1Deferred();
        deferred.resolve(this.domainAccessStore.getMediatorAccessControlEntries(uid).toArray(new MasterAccessControlEntry[0]));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalDomainAccessControllerProvider.GetMediatorAccessControlEntries1Deferred> getMediatorAccessControlEntries(String domain, String interfaceName) {
        GlobalDomainAccessControllerProvider.GetMediatorAccessControlEntries1Deferred deferred = new GlobalDomainAccessControllerProvider.GetMediatorAccessControlEntries1Deferred();
        deferred.resolve(this.domainAccessStore.getMediatorAccessControlEntries(domain, interfaceName).toArray(new MasterAccessControlEntry[0]));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalDomainAccessControllerProvider.GetOwnerAccessControlEntries1Deferred> getOwnerAccessControlEntries(String uid) {
        GlobalDomainAccessControllerProvider.GetOwnerAccessControlEntries1Deferred deferred = new GlobalDomainAccessControllerProvider.GetOwnerAccessControlEntries1Deferred();
        deferred.resolve(this.domainAccessStore.getOwnerAccessControlEntries(uid).toArray(new OwnerAccessControlEntry[0]));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalDomainAccessControllerProvider.GetOwnerAccessControlEntries1Deferred> getOwnerAccessControlEntries(String domain, String interfaceName) {
        GlobalDomainAccessControllerProvider.GetOwnerAccessControlEntries1Deferred deferred = new GlobalDomainAccessControllerProvider.GetOwnerAccessControlEntries1Deferred();
        deferred.resolve(this.domainAccessStore.getOwnerAccessControlEntries(domain, interfaceName).toArray(new OwnerAccessControlEntry[0]));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalDomainAccessControllerProvider.GetMasterRegistrationControlEntriesDeferred> getMasterRegistrationControlEntries(String uid) {
        assert (false) : "method not implemented";
        return null;
    }

    public Promise<GlobalDomainAccessControllerProvider.GetMediatorRegistrationControlEntriesDeferred> getMediatorRegistrationControlEntries(String uid) {
        assert (false) : "method not implemented";
        return null;
    }

    public Promise<GlobalDomainAccessControllerProvider.GetOwnerRegistrationControlEntriesDeferred> getOwnerRegistrationControlEntries(String uid) {
        assert (false) : "method not implemented";
        return null;
    }
}

