/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol.global;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.joynr.accesscontrol.DomainAccessControlProvisioning;
import io.joynr.accesscontrol.DomainAccessControlStoreEhCache;
import io.joynr.accesscontrol.global.GlobalDomainAccessStoreAdmin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import joynr.infrastructure.DacTypes.DomainRoleEntry;
import joynr.infrastructure.DacTypes.MasterAccessControlEntry;
import joynr.infrastructure.DacTypes.OwnerAccessControlEntry;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

@Singleton
public class GlobalDomainAccessStoreAdminEhCache
extends DomainAccessControlStoreEhCache
implements GlobalDomainAccessStoreAdmin {
    @Inject
    public GlobalDomainAccessStoreAdminEhCache(CacheManager ehCacheManager, DomainAccessControlProvisioning domainAccessControlProvisioning) {
        super(ehCacheManager, domainAccessControlProvisioning);
    }

    @Override
    public List<MasterAccessControlEntry> getAllMasterAclEntries() {
        ArrayList<MasterAccessControlEntry> result = new ArrayList<MasterAccessControlEntry>();
        Cache aclCache = this.getCache(DomainAccessControlStoreEhCache.CacheId.MASTER_ACL);
        Map aclMap = aclCache.getAll((Collection)aclCache.getKeys());
        for (Map.Entry thisMapEntry : aclMap.entrySet()) {
            Element thisElement = (Element)thisMapEntry.getValue();
            MasterAccessControlEntry objectValue = (MasterAccessControlEntry)GlobalDomainAccessStoreAdminEhCache.getElementValue((Element)thisElement);
            result.add(objectValue);
        }
        return result;
    }

    @Override
    public List<OwnerAccessControlEntry> getAllOwnerAclEntries() {
        ArrayList<OwnerAccessControlEntry> result = new ArrayList<OwnerAccessControlEntry>();
        Cache aclCache = this.getCache(DomainAccessControlStoreEhCache.CacheId.OWNER_ACL);
        Map aclMap = aclCache.getAll((Collection)aclCache.getKeys());
        for (Map.Entry thisMapEntry : aclMap.entrySet()) {
            Element thisElement = (Element)thisMapEntry.getValue();
            OwnerAccessControlEntry objectValue = (OwnerAccessControlEntry)GlobalDomainAccessStoreAdminEhCache.getElementValue((Element)thisElement);
            result.add(objectValue);
        }
        return result;
    }

    @Override
    public List<DomainRoleEntry> getAllDomainRoleEntries() {
        ArrayList result = Lists.newArrayList();
        Cache roleCache = this.getCache(DomainAccessControlStoreEhCache.CacheId.DOMAIN_ROLES);
        Map roleMap = roleCache.getAll((Collection)roleCache.getKeys());
        Iterator iterator = roleMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Element thisElement = (Element)iterator.next().getValue();
            DomainRoleEntry objectValue = (DomainRoleEntry)GlobalDomainAccessStoreAdminEhCache.getElementValue((Element)thisElement);
            result.add(objectValue);
        }
        return result;
    }
}

