/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol.global;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.joynr.accesscontrol.DomainAccessControlStore;
import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.Promise;
import joynr.infrastructure.DacTypes.ChangeType;
import joynr.infrastructure.DacTypes.DomainRoleEntry;
import joynr.infrastructure.DacTypes.Role;
import joynr.infrastructure.GlobalDomainRoleControllerAbstractProvider;
import joynr.infrastructure.GlobalDomainRoleControllerProvider;

@Singleton
public class GlobalDomainRoleControllerProviderImpl
extends GlobalDomainRoleControllerAbstractProvider {
    private final DomainAccessControlStore domainAccessStore;

    @Inject
    public GlobalDomainRoleControllerProviderImpl(DomainAccessControlStore domainAccessStore) {
        this.domainAccessStore = domainAccessStore;
    }

    public Promise<GlobalDomainRoleControllerProvider.GetDomainRolesDeferred> getDomainRoles(String uid) {
        GlobalDomainRoleControllerProvider.GetDomainRolesDeferred deferred = new GlobalDomainRoleControllerProvider.GetDomainRolesDeferred();
        deferred.resolve(this.domainAccessStore.getDomainRoles(uid).toArray(new DomainRoleEntry[0]));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalDomainRoleControllerProvider.UpdateDomainRoleDeferred> updateDomainRole(DomainRoleEntry updatedEntry) {
        GlobalDomainRoleControllerProvider.UpdateDomainRoleDeferred deferred = new GlobalDomainRoleControllerProvider.UpdateDomainRoleDeferred();
        boolean updateSuccess = this.domainAccessStore.updateDomainRole(updatedEntry);
        if (updateSuccess) {
            this.fireDomainRoleEntryChanged(ChangeType.UPDATE, updatedEntry, new String[0]);
        }
        deferred.resolve(Boolean.valueOf(updateSuccess));
        return new Promise((AbstractDeferred)deferred);
    }

    public Promise<GlobalDomainRoleControllerProvider.RemoveDomainRoleDeferred> removeDomainRole(String uid, Role role) {
        GlobalDomainRoleControllerProvider.RemoveDomainRoleDeferred deferred = new GlobalDomainRoleControllerProvider.RemoveDomainRoleDeferred();
        boolean removeSuccess = this.domainAccessStore.removeDomainRole(uid, role);
        if (removeSuccess) {
            DomainRoleEntry removedEntry = new DomainRoleEntry(uid, null, role);
            this.fireDomainRoleEntryChanged(ChangeType.REMOVE, removedEntry, new String[0]);
        }
        deferred.resolve(Boolean.valueOf(removeSuccess));
        return new Promise((AbstractDeferred)deferred);
    }
}

