/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.maven.enricher.api;

import io.jshift.kit.common.Configs;
import io.jshift.kit.config.resource.ProcessorConfig;
import io.jshift.maven.enricher.api.model.Configuration;
import java.util.Map;

public class EnricherConfig {
    private static final String ENRICHER_PROP_PREFIX = "jshift.enricher";
    private final String name;
    private final Configuration configuration;

    public EnricherConfig(String name, Configuration configuration) {
        this.name = name;
        this.configuration = configuration;
    }

    public String get(Configs.Key key) {
        return this.get(key, key.def());
    }

    public Map<String, String> getRawConfig() {
        return this.configuration.getProcessorConfig().orElse(ProcessorConfig.EMPTY).getConfigMap(this.name);
    }

    public String get(Configs.Key key, String defaultVal) {
        String val = this.configuration.getProcessorConfig().orElse(ProcessorConfig.EMPTY).getConfig(this.name, key.name());
        if (val == null) {
            String fullKey = "jshift.enricher." + this.name + "." + key;
            val = this.configuration.getPropertyWithSystemOverride(fullKey);
        }
        return val != null ? val : defaultVal;
    }
}

