/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.maven.enricher.api;

import io.jshift.kit.common.KitLogger;
import io.jshift.kit.config.resource.GroupArtifactVersion;
import io.jshift.maven.enricher.api.model.Configuration;
import io.jshift.maven.enricher.api.model.Dependency;
import io.jshift.maven.enricher.api.util.ProjectClassLoaders;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface EnricherContext {
    public GroupArtifactVersion getGav();

    public KitLogger getLog();

    public Configuration getConfiguration();

    public Map<String, String> getProcessingInstructions();

    public void setProcessingInstructions(Map<String, String> var1);

    public File getProjectDirectory();

    public ProjectClassLoaders getProjectClassLoaders();

    public boolean hasPlugin(String var1, String var2);

    public List<Dependency> getDependencies(boolean var1);

    default public boolean hasDependency(String groupId, String artifactId) {
        return this.getDependencyVersion(groupId, artifactId).isPresent();
    }

    default public Optional<String> getDependencyVersion(String groupId, String artifactId) {
        List<Dependency> dependencies = this.getDependencies(true);
        for (Dependency dep : dependencies) {
            String scope = dep.getScope();
            if ("test".equals(scope) || artifactId != null && !artifactId.equals(dep.getGav().getArtifactId()) || !dep.getGav().getGroupId().equals(groupId)) continue;
            return Optional.of(dep.getGav().getVersion());
        }
        return Optional.empty();
    }

    public Object getProperty(String var1);
}

