/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.maven.enricher.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.jshift.kit.build.service.docker.ImageConfiguration;
import io.jshift.kit.common.KitLogger;
import io.jshift.kit.common.util.MavenUtil;
import io.jshift.kit.config.resource.GroupArtifactVersion;
import io.jshift.kit.config.resource.ProcessorConfig;
import io.jshift.kit.config.resource.ResourceConfig;
import io.jshift.maven.enricher.api.EnricherContext;
import io.jshift.maven.enricher.api.model.Configuration;
import io.jshift.maven.enricher.api.model.Dependency;
import io.jshift.maven.enricher.api.util.MavenConfigurationExtractor;
import io.jshift.maven.enricher.api.util.ProjectClassLoaders;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenEnricherContext
implements EnricherContext {
    private Configuration configuration;
    private Settings settings;
    private Map<String, String> processingInstruction;
    private MavenProject project;
    private KitLogger log;
    private MavenSession session;
    private Properties properties;

    private MavenEnricherContext() {
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public Map<String, String> getProcessingInstructions() {
        return this.processingInstruction;
    }

    @Override
    public void setProcessingInstructions(Map<String, String> instruction) {
        this.processingInstruction = instruction;
    }

    @Override
    public KitLogger getLog() {
        return this.log;
    }

    @Override
    public GroupArtifactVersion getGav() {
        return new GroupArtifactVersion(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
    }

    @Override
    public File getProjectDirectory() {
        return this.getProject().getBasedir();
    }

    @Override
    public List<Dependency> getDependencies(boolean transitive) {
        Set artifacts = transitive ? this.getProject().getArtifacts() : this.getProject().getDependencyArtifacts();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (Artifact artifact : artifacts) {
            dependencies.add(new Dependency(new GroupArtifactVersion(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()), artifact.getType(), artifact.getScope(), artifact.getFile()));
        }
        return dependencies;
    }

    @Override
    public boolean hasPlugin(String groupId, String artifactId) {
        if (groupId != null) {
            return MavenUtil.hasPlugin((MavenProject)this.getProject(), (String)groupId, (String)artifactId);
        }
        return MavenUtil.hasPluginOfAnyGroupId((MavenProject)this.getProject(), (String)artifactId);
    }

    @Override
    public ProjectClassLoaders getProjectClassLoaders() {
        return new ProjectClassLoaders(MavenUtil.getCompileClassLoader((MavenProject)this.getProject()));
    }

    @Override
    public Object getProperty(String key) {
        return this.properties != null ? this.properties.getProperty(key) : null;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public String getDockerJsonConfigString(Settings settings, String serverId) {
        Server server = this.getServer(settings, serverId);
        if (server == null) {
            return "";
        }
        JsonObject auth = new JsonObject();
        auth.add("username", (JsonElement)new JsonPrimitive(server.getUsername()));
        auth.add("password", (JsonElement)new JsonPrimitive(server.getPassword()));
        String mail = this.getConfigurationValue(server, "email");
        if (!StringUtils.isBlank((CharSequence)mail)) {
            auth.add("email", (JsonElement)new JsonPrimitive(mail));
        }
        JsonObject json = new JsonObject();
        json.add(serverId, (JsonElement)auth);
        return json.toString();
    }

    public Server getServer(Settings settings, String serverId) {
        if (settings == null || StringUtils.isBlank((CharSequence)serverId)) {
            return null;
        }
        return settings.getServer(serverId);
    }

    private String getConfigurationValue(Server server, String key) {
        Xpp3Dom configuration = (Xpp3Dom)server.getConfiguration();
        if (configuration == null) {
            return null;
        }
        Xpp3Dom node = configuration.getChild(key);
        if (node == null) {
            return null;
        }
        return node.getValue();
    }

    public static class Builder {
        private MavenEnricherContext ctx = new MavenEnricherContext();
        private ResourceConfig resources;
        private List<ImageConfiguration> images;
        private ProcessorConfig processorConfig;

        public Builder session(MavenSession session) {
            this.ctx.session = session;
            return this;
        }

        public Builder log(KitLogger log) {
            this.ctx.log = log;
            return this;
        }

        public Builder project(MavenProject project) {
            this.ctx.project = project;
            return this;
        }

        public Builder config(ProcessorConfig config) {
            this.processorConfig = config;
            return this;
        }

        public Builder resources(ResourceConfig resources) {
            this.resources = resources;
            return this;
        }

        public Builder images(List<ImageConfiguration> images) {
            this.images = images;
            return this;
        }

        public Builder settings(Settings settings) {
            this.ctx.settings = settings;
            return this;
        }

        public Builder properties(Properties properties) {
            this.ctx.properties = properties;
            return this;
        }

        public Builder processingInstructions(Map<String, String> pi) {
            this.ctx.processingInstruction = pi;
            return this;
        }

        public MavenEnricherContext build() {
            this.ctx.configuration = new Configuration.Builder().properties(this.ctx.project.getProperties()).images(this.images).resource(this.resources).processorConfig(this.processorConfig).pluginConfigLookup((system, id) -> {
                if (!"maven".equals(system)) {
                    return Optional.empty();
                }
                Plugin plugin = this.ctx.project.getPlugin(id);
                if (plugin == null) {
                    return Optional.empty();
                }
                return Optional.of(MavenConfigurationExtractor.extract((Xpp3Dom)plugin.getConfiguration()));
            }).secretConfigLookup(id -> {
                Settings settings = this.ctx.session.getSettings();
                if (settings == null || StringUtils.isBlank((CharSequence)id)) {
                    return Optional.empty();
                }
                Server server = settings.getServer(id);
                if (server == null) {
                    return Optional.empty();
                }
                Map<String, Object> config = MavenConfigurationExtractor.extract((Xpp3Dom)server.getConfiguration());
                config.put("id", server.getId());
                config.put("username", server.getUsername());
                config.put("password", server.getPassword());
                return Optional.of(config);
            }).build();
            return this.ctx;
        }
    }
}

