/*
 * Decompiled with CFR 0.152.
 */
package io.jshift.maven.enricher.api.model;

import io.jshift.kit.build.service.docker.ImageConfiguration;
import io.jshift.kit.config.resource.ProcessorConfig;
import io.jshift.kit.config.resource.ResourceConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Configuration {
    private Properties properties = new Properties();
    private List<ImageConfiguration> images;
    private ResourceConfig resource;
    private BiFunction<String, String, Optional<Map<String, Object>>> pluginConfigLookup;
    private Function<String, Optional<Map<String, Object>>> secretConfigLookup;
    private ProcessorConfig processorConfig;

    private Configuration() {
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Optional<List<ImageConfiguration>> getImages() {
        return Optional.ofNullable(this.images);
    }

    public Optional<ResourceConfig> getResource() {
        return Optional.ofNullable(this.resource);
    }

    public Optional<ProcessorConfig> getProcessorConfig() {
        return Optional.ofNullable(this.processorConfig);
    }

    public Optional<Map<String, Object>> getPluginConfiguration(String system, String id) {
        return this.pluginConfigLookup.apply(system, id);
    }

    public Optional<Map<String, Object>> getSecretConfiguration(String id) {
        return this.secretConfigLookup.apply(id);
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public String getPropertyWithSystemOverride(String name) {
        String ret = System.getProperty(name);
        if (ret != null) {
            return ret;
        }
        return this.getProperty(name);
    }

    public static class Builder {
        private Configuration cfg = new Configuration();

        public Builder properties(Properties props) {
            this.cfg.properties = props;
            return this;
        }

        public Builder images(List<ImageConfiguration> images) {
            this.cfg.images = images;
            return this;
        }

        public Builder resource(ResourceConfig resource) {
            this.cfg.resource = resource;
            return this;
        }

        public Builder processorConfig(ProcessorConfig config) {
            this.cfg.processorConfig = config;
            return this;
        }

        public Builder pluginConfigLookup(BiFunction<String, String, Optional<Map<String, Object>>> pluginConfigLookup) {
            this.cfg.pluginConfigLookup = pluginConfigLookup;
            return this;
        }

        public Builder secretConfigLookup(Function<String, Optional<Map<String, Object>>> secretConfigLookup) {
            this.cfg.secretConfigLookup = secretConfigLookup;
            return this;
        }

        public Configuration build() {
            return this.cfg;
        }
    }
}

